//
// VARIABLES AND CONSTANTS
//
var variant = "eCOR";


// section/file name and string constants 
var instructionsRefName = "instructions_consent";
var pretestRefName = "pretest";
var trainingRefName = "training";
var visRefName = "vis";
var catchRefName = "catch";
var breakRefName = "break";
var questionRefName = "question";
var questionnaireRefName = "questionnaire";
var completioncodeRefName = "completioncode";
var pageTypeSeqnoOfPages_total = [[instructionsRefName,1],[pretestRefName,1],[trainingRefName,6],[visRefName,20],[catchRefName,3],[breakRefName,2],[questionnaireRefName,1]]; 



// constants
var pagestr = 'page';
var pageNotCompleteError = "Please provide an answer for the above first.";
var pageMaxTimeInSec = 15;
var lowestReliableTotalQuesCorrectness = 0.0; //as a ratio i.e., no of correct / total no.  
var lowestReliableTotalCatchCorrectness = 1; //as a ratio i.e., no of correct / total no.

// other data storing variables 
var nextPageForPages = {};
var showTimerOnPageForPages = {};
var pageHasMultiChoiceButtons = {};
var pageIsAProblemPage = {};

var currentPageNo;
var noOfPages_total;
var pageArray;

var totalNoOfProblems;
var totalNoOfQues;
var totalNoOfCatches;
var noOfCorrectProblemsSoFar; 
var noOfCorrectQuesSoFar;
var noOfCorrectCatchesSoFar;  
var noOfProblemsCompleted;
var correctAnswersToQuestions;
var correctAnswersToCatches;
var totalNoOfBreaks;
var noOfBreakCompleted;
var inattentiveParticipant;

var correctStatsDivID = "breakCorrectStats";   

var startTimes = [];
var endTimes = [];

// debug functions
var DEBUG_showAllPages = false;  // displays all pages at once
var	DEBUG_firstPage = 1;         // changes the first page that appears




//
// INITIALIZATION CODE AFTER PAGE LOADING
//


function onLoad() {


    // check what device and software compatibility
    if (!isDeviceAppropriate()){
        var errmsg = "<p style='line-height:1.6;'>Your device is not compatible with this job.<br>Note that mobile devices are not permitted.</p>";
		document.write(errmsg);
    }
    if (!isBrowserAppropriate()){
        var errmsg = "<p style='line-height:1.5;'>Your web browser is not compatible with this job.<br><br>"+
		             "Please try to: <br />"+
		             "- update your web browser to a later version, or <br />"+
		             "- use a different web browser.</p>";
		document.write(errmsg);
    }
    


    // created divs with page numbers as id
    noOfPages_total = 0;
    pageArray = [];
    
    for (var i=0; i<pageTypeSeqnoOfPages_total.length; i++){
        //var noOfFiles = getFileCountInDir(pageTypeSeqnoOfPages_total[i][0]+"/")
        //pageTypeSeqnoOfPages_total[i][1] = noOfFiles;
        var noOfFiles = pageTypeSeqnoOfPages_total[i][1];
        var pageType = pageTypeSeqnoOfPages_total[i][0]; 
        var allHTMLforType = "";
        for (var j=1; j<=noOfFiles; j++){
            noOfPages_total += 1;
            var pageNo = noOfPages_total;
            var pageNoStr = getPageNoStr(pageNo);
            if (allHTMLforType == ""){
                allHTMLforType = "<div id="+pageNoStr+"></div>"
            } else {
                allHTMLforType += "<div id="+pageNoStr+"></div>"
            }
            pageArray.push(pageNoStr);
            
            var nextPageNoStr = getPageNoStr(pageNo+1);
            nextPageForPages[pageNoStr] = nextPageNoStr; 
        }
        if ((pageType == catchRefName) || (pageType == breakRefName)){
            pageType = visRefName;
        }
        document.getElementById(pageType).innerHTML += allHTMLforType;
    }
    
    
    // create a time field for each page 
    for(var i in pageArray) {
		var page = pageArray[i];
		startTimes[page] = 0;
		endTimes[page] = 0;
		
		// Create a hidden form field that will enventually store page completion time.
		var divBlock = document.getElementById(page);
		var timeField = document.createElement('input');
		timeField.setAttribute('type', 'hidden');
		timeField.setAttribute('id', 'timeOn' + page);
		timeField.setAttribute('name', 'timeOn' + page);
		timeField.setAttribute('value', 0);
		divBlock.appendChild(timeField);
	}
	var timeField = document.createElement('input');
	timeField.setAttribute('type', 'hidden');
	timeField.setAttribute('id', 'timeOnpages1to'+(noOfPages_total));
	timeField.setAttribute('name','timeOnpages1to'+(noOfPages_total));
	timeField.setAttribute('value', 0);
	divBlock.appendChild(timeField);
	
	
	
    // build up the material that should be shown on each page
    var contentsOrderValue = ""
    
    // ... build instructions and consent page
    currentPageNo = 1;
    var pageTypeIndex = 0;
    contentsOrderValue += "i,";
    document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforInstructionsConsent(pageTypeSeqnoOfPages_total[pageTypeIndex][0]+"/text.html", noOfPages_total);
    showTimerOnPageForPages[getCurrentPageNoStr()] = false;
    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = false;
    pageIsAProblemPage[getCurrentPageNoStr()] = false;
	currentPageNo += 1;
	pageTypeIndex += 1;
	
	 // ... build pretest page
    contentsOrderValue += "p,";
    document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforPreTest(pageTypeSeqnoOfPages_total[pageTypeIndex][0]+"/text.html", noOfPages_total);
    showTimerOnPageForPages[getCurrentPageNoStr()] = false;
    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = false;
    pageIsAProblemPage[getCurrentPageNoStr()] = false;
	currentPageNo += 1;
	pageTypeIndex += 1;
	
	// ... build training pages 
	contentsOrderValue += "ti,";
	document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforTrainingInfo(pageTypeSeqnoOfPages_total[pageTypeIndex][0]+"/intro_text.html", noOfPages_total);
    showTimerOnPageForPages[getCurrentPageNoStr()] = false;
    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = false;
    pageIsAProblemPage[getCurrentPageNoStr()] = false;
	currentPageNo += 1;
	var noOfTrainingQues = pageTypeSeqnoOfPages_total[pageTypeIndex][1]-2;
	for(var i=1; i<=noOfTrainingQues; i++) {
	    var questionStr = 't'+i;
		var isLastQuestion = (i==noOfTrainingQues);
		contentsOrderValue += questionStr+",";
		document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforTrainingQuestion(trainingRefName, questionStr, i, noOfPages_total, true, isLastQuestion, noOfTrainingQues);
		showTimerOnPageForPages[getCurrentPageNoStr()] = false;
		pageHasMultiChoiceButtons[getCurrentPageNoStr()] = true;
		pageIsAProblemPage[getCurrentPageNoStr()] = false;
		currentPageNo += 1;
	}
	// ... ... add hidden fields to save the answer and time for each training question
	for(var i=1; i<=noOfTrainingQues; i++) {
        var questionStr = 't'+i;
        var qsuffix = ['a','t'];
        for (s in qsuffix){
            var newinput = document.createElement('input');
		    newinput.type = "hidden";
		    newinput.id = questionStr+qsuffix[s];
		    newinput.name = questionStr+qsuffix[s];
		    newinput.value = "";
		    document.getElementById('hiddenFormInputs').appendChild(newinput);
		}
    }
    contentsOrderValue += "tf,";
	document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforTrainingInfo(pageTypeSeqnoOfPages_total[pageTypeIndex][0]+"/end_text.html", noOfPages_total);
    showTimerOnPageForPages[getCurrentPageNoStr()] = false;
    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = false;
    pageIsAProblemPage[getCurrentPageNoStr()] = false;
	currentPageNo += 1;		
    pageTypeIndex += 1;
	
	
	// ... identify where the catch questions should be placed 
	var qBlockSizes_catch = [];
	var noOfCatches = pageTypeSeqnoOfPages_total[pageTypeIndex+1][1];
	var qblockNo_catch = noOfCatches + 1;
	var qblockMinSize_catch = Math.floor(pageTypeSeqnoOfPages_total[pageTypeIndex][1] / qblockNo_catch);
	var qblockExtra_catch = pageTypeSeqnoOfPages_total[pageTypeIndex][1] % qblockNo_catch;
	for (i=0; i < qblockNo_catch; i++){
	    var n = qblockMinSize_catch; 
	    if (qblockExtra_catch > 0){
	        n += 1;
	        qblockExtra_catch -= 1;
	    }
	    qBlockSizes_catch.push(n); 
	}

	// ... identify where the break questions should be placed 
	var qBlockSizes_break = [];
	var noOfBreaks = pageTypeSeqnoOfPages_total[pageTypeIndex+2][1];
	var qblockNo_break = noOfBreaks;
	var noOfProblems = pageTypeSeqnoOfPages_total[pageTypeIndex][1] + noOfCatches;
	var qblockMinSize_break = Math.floor(noOfProblems / qblockNo_break);
	var qblockExtra_break = noOfProblems % qblockNo_break;
	for (i=0; i < qblockNo_break; i++){
	    var n = qblockMinSize_break; 
	    if (qblockExtra_break > 0){
	        n += 1;
	        qblockExtra_break -= 1;
	    }
	    qBlockSizes_break.push(n); 
	}
	
	// ... build questions in study pages and the catch questions in between
	var questionOrder = questionSequence(pageTypeSeqnoOfPages_total[pageTypeIndex][1]);
	var questionOrderValue = "";
	var qblocksize_catch = 0;
	var qblockindex_catch = 0;
	var catchindex = 1;
    var qblocksize_break = 0;
	var qblockindex_break = 0;
	var breakindex = 1;
	var problemNo = 1;
	for(var i=0; i<questionOrder.length; i++) {
	    var questionNumber = questionOrder[i];
		var questionStr = 'q'+questionNumber;
		contentsOrderValue += questionStr+",";
		document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforQuestion(visRefName, questionStr, problemNo, noOfPages_total, true);
		questionOrderValue += questionNumber+",";
		showTimerOnPageForPages[getCurrentPageNoStr()] = true;
		pageHasMultiChoiceButtons[getCurrentPageNoStr()] = true;
		pageIsAProblemPage[getCurrentPageNoStr()] = true;
		currentPageNo += 1;
		qblocksize_catch += 1;
		qblocksize_break += 1;
		problemNo += 1;

		if ((qblocksize_break >= qBlockSizes_break[qblockindex_break]) && (breakindex <= noOfBreaks)){
		    contentsOrderValue += "b,";
            var textpath = breakRefName+"/text.html";
            document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforBreak(textpath, breakindex, noOfPages_total);
		    showTimerOnPageForPages[getCurrentPageNoStr()] = false;
		    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = false;
		    pageIsAProblemPage[getCurrentPageNoStr()] = false;
		    currentPageNo += 1;
		    qblocksize_break = 0;
		    qblockindex_break += 1;
		    breakindex += 1;
		}
		
		if ((qblocksize_catch >= qBlockSizes_catch[qblockindex_catch]) && (catchindex <= noOfCatches)){
            var catchStr = 'c'+catchindex;
            contentsOrderValue += catchStr+",";
            document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforQuestion(catchRefName, catchStr, problemNo, noOfPages_total, true);
		    showTimerOnPageForPages[getCurrentPageNoStr()] = true;
		    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = true;
		    pageIsAProblemPage[getCurrentPageNoStr()] = true;
		    currentPageNo += 1;
		    problemNo += 1; 
		    qblocksize_catch = 0;
		    qblockindex_catch += 1;
		    qblocksize_break += 1;
		    catchindex += 1;
		}
		
		if ((qblocksize_break >= qBlockSizes_break[qblockindex_break]) && (breakindex <= noOfBreaks)){
            contentsOrderValue += "b,";
            var textpath = breakRefName+"/text.html";
            document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforBreak(textpath, breakindex, noOfPages_total);
		    showTimerOnPageForPages[getCurrentPageNoStr()] = false;
		    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = false;
		    pageIsAProblemPage[getCurrentPageNoStr()] = false;
		    currentPageNo += 1;
		    qblocksize_break = 0;
		    qblockindex_break += 1;
		    breakindex += 1;
		}
    }
    totalNoOfProblems = problemNo-1;
    totalNoOfBreaks = breakindex-1;
    totalNoOfQues = questionOrder.length;
    totalNoOfCatches = noOfCatches;

    
    // ... ... add hidden fields to save the answer and time for each question
    for(var i=1; i<=pageTypeSeqnoOfPages_total[pageTypeIndex][1]; i++) {
        var questionStr = 'q'+i;
        var qsuffix = ['a','t'];
        for (s in qsuffix){
            var newinput = document.createElement('input');
		    newinput.type = "hidden";
		    newinput.id = questionStr+qsuffix[s];
		    newinput.name = questionStr+qsuffix[s];
		    newinput.value = "";
		    document.getElementById('hiddenFormInputs').appendChild(newinput);
		}
    }
    // ... ... add hidden fields to save the answer and time for each catch
    for(var i=1; i<=pageTypeSeqnoOfPages_total[pageTypeIndex+1][1]; i++) {
        var questionStr = 'c'+i;
        var qsuffix = ['a','t'];
        for (s in qsuffix){
            var newinput = document.createElement('input');
		    newinput.type = "hidden";
		    newinput.id = questionStr+qsuffix[s];
		    newinput.name = questionStr+qsuffix[s];
		    newinput.value = "";
		    document.getElementById('hiddenFormInputs').appendChild(newinput);
		}
    }		
    pageTypeIndex += 3; // +1 for measured questions, +1 for catch questions, +1 for break pages

    
    // ... build questionnaire page
    contentsOrderValue += "f,";     
    document.getElementById(getCurrentPageNoStr()).innerHTML += getHTMLforQuestionnaire(pageTypeSeqnoOfPages_total[pageTypeIndex][0]+"/text.html", noOfPages_total);
    document.getElementById("questionnaireCountry").innerHTML += getHTML(pageTypeSeqnoOfPages_total[pageTypeIndex][0]+"/listofcountries.html");
    showTimerOnPageForPages[getCurrentPageNoStr()] = false;
    pageHasMultiChoiceButtons[getCurrentPageNoStr()] = false;
    pageIsAProblemPage[getCurrentPageNoStr()] = false;
	currentPageNo += 1;
	pageTypeIndex += 1;
	
	
	// Set some global variables
    noOfCorrectProblemsSoFar = 0; 
    noOfProblemsCompleted = 0;
    loadCorrectAnswersToQuestionsAndCatches();
    noOfBreakCompleted=0;
    noOfCorrectQuesSoFar=0;
    noOfCorrectCatchesSoFar=0;  
    inattentiveParticipant=undefined;
    
    
    // Make the whole form visible (it is invisible by default to prevent users without javascript
	// enabled from seeing it until they enable it)
	document.getElementById('form').style.display = "block";
	
    // Which page to show first
    var firstPage = 'page'+DEBUG_firstPage;
	currentVisiblePages = [firstPage];
	showSinglePage(firstPage);
    
    currentPageNo = firstPage;


    // Update hidden form variables from post data
	document.getElementById('variant').value = variant;
	document.getElementById('questionOrderField').value = questionOrderValue.replace(/,$/, ''); 
	document.getElementById('contentsOrderField').value = contentsOrderValue.replace(/,$/, ''); 
	
}


// 
// GET HTML FOR DIFFERENT TYPES OF PAGES
//

function getHTMLforInstructionsConsent(textpath,noOfPages_total){
    var s = "";
    
    texthtml = getHTML(textpath);
    currentPageNoStr = getCurrentPageNoStr();
    nextPageNoStr = getPageNoStr(currentPageNo+1);
    pageOutOfPages = getPageOutOfPages(noOfPages_total);
    
    s += '<p>Page '+pageOutOfPages+'</p><hr>';
    s += texthtml;
    s += "<p>If you agree with the above, enter your CrowdFlower contributor ID below and click on the 'Next' button to start the job.</p>";
    s += '<p>Contributor ID: &nbsp; <input type="text" maxlength="80" size="20" id="contributorID" name="contributorID" /></p>';
    s += '<hr><br>';
    s += '<img src="img/logos.png" alt="" height="100px" style="position: absolute;right:0;" />';
    s += '<input id="firstbutton" type="button" name="next" value="Next page" onClick="';
    s += "if (checkAllFields('"+currentPageNoStr+"')){";
    s += "if (isContributorIDInFieldUnique()) {";
    s += "if (saveContributorIDInField()) {showSinglePage('"+nextPageNoStr+"');} else { document.getElementById('form').style.display = 'none'; document.getElementsByTagName('body')[0].innerHTML = 'Sorry, this job does not seem to work on your computer.'; } ";
    s += "} else {document.getElementById('form').style.display = 'none'; document.getElementsByTagName('body')[0].innerHTML = 'You have already partially or fully completed this job, thus you cannot take this job once again.';} ";    
    s += "} else {alert('"+pageNotCompleteError+"');}";
    s += '">';
    s += '<p style="line-height:0.1;"><font color="#999999"><div id="firstbuttonmessage" style="line-height:1.3;">&nbsp;&nbsp;You cannot return to this page afterwards.<br>&nbsp;&nbsp;Ensure that your contributor ID is correct, otherwise we will not be able to pay you.</font></p>';
    s += '<script type="text/javascript">if (DEBUG_showAllPages) document.write("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");</script>';
    
    return s;   
}

function getHTMLforPreTest(textpath,noOfPages_total){
    var s = "";
    
    texthtml = getHTML(textpath);
    currentPageNoStr = getCurrentPageNoStr();
    nextPageNoStr = getPageNoStr(currentPageNo+1);
    pageOutOfPages = getPageOutOfPages(noOfPages_total);
    
    s += '<p>Page '+pageOutOfPages+'</p><hr>';
    s += '<h3>Pre-Questions</h3>';
    s += texthtml;
    s += '<hr><br>';
    s += '<input type="button" name="next" value="Next page" onClick="';
    s += "if (checkAllFields('"+currentPageNoStr+"')){";
    s += "if (passedPreTest()) {";
    s += "showSinglePage('"+nextPageNoStr+"');";
    s += "} else {document.getElementById('form').style.display = 'none'; document.getElementsByTagName('body')[0].innerHTML = 'Sorry, you do not satisfy the requirements of this job.';}";
    s += "} else {alert('"+pageNotCompleteError+"');}";
    s += '">';
    s += '<script type="text/javascript">if (DEBUG_showAllPages) document.write("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");</script>';
    
    return s;   

}


function getHTMLforTrainingInfo (textpath,noOfPages_total){
    var s = "";
    
    texthtml = getHTML(textpath);
    currentPageNoStr = getCurrentPageNoStr();
    nextPageNoStr = getPageNoStr(currentPageNo+1);
    pageOutOfPages = getPageOutOfPages(noOfPages_total);
    
    s += '<p>Page '+pageOutOfPages+'</p><hr>';
    s += '<h3>Training</h3>';
    s += texthtml;
    s += '<hr><br>';
    s += '<input id="traininginfobutton" type="button" name="next" value="Next page" onClick="';
    s += "if (checkAllFields('"+currentPageNoStr+"')){showSinglePage('"+nextPageNoStr+"');} else {alert('"+pageNotCompleteError+"');}";
    s += '">';
    s += '<p style="line-height:0.1;"><font color="#999999"><div id="trainingintrobutton" style="line-height:1.3;">&nbsp;&nbsp;You cannot return to this page afterwards.<br>&nbsp;&nbsp;Ensure you understood this information.</font></p>';
    s += '<script type="text/javascript">if (DEBUG_showAllPages) document.write("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");</script>';
    
    return s;   
}



function getHTMLforTrainingQuestion(imgdir, question, problemNo, noOfPages_total, saveAnswer, checkNoOfCorrectAnswers, noOfTrainingQues) {
	var s = "";

    currentPageNoStr = getPageNoStr(currentPageNo);
    nextPageNoStr = getPageNoStr(currentPageNo+1);
    pageOutOfPages = getPageOutOfPages(noOfPages_total);
    
    var imgSuffix = ".png";
    var trainingAnswerDivID = "traininganswer_"+question;
    var trainingChoicesDivID = "trainingchoices_"+question;
    choicesText = getChoices(questionRefName+'/','qc');  
    textHTML = getHTML(questionRefName+'/q.html');
    imageHTML = imgdir +'/'+question+imgSuffix;
    answerHTML = getHTML(imgdir +'/'+question+"a.html");
    questionHTML = "Your answer: <br/><br/>";  
    
    s += '<p>Page '+pageOutOfPages+'</p><hr>';    
    s += '<h3>Training Problem '+problemNo+'</h3>';
    s += '<div style="font-size:14px;" id="training'+problemNo+'">';
    
    for (var i  = 0; i<choicesText.length; i++){
        buttonId = "button_"+currentPageNoStr+"_"+i;
        questionHTML += '<input type="button" id="'+buttonId+'" name="'+question+'" value="'+choicesText[i]+'"';
        questionHTML += ' style="height:40px; width:60px; font-size: 12px; margin: 5px 8px; background-color:#EBEDEF; border:2; border-radius:10px;"';
        questionHTML += 'onClick="';
        if (saveAnswer){
            questionHTML += "saveQuestionAnswer('"+question+"a', '"+choicesText[i]+"'); ";
            questionHTML += "saveQuestionTime('"+question+"t', '"+currentPageNoStr+"'); ";
        }
        
        questionHTML += "showTrainingAnswer(";
        questionHTML += "'"+trainingAnswerDivID+"', '"+trainingChoicesDivID+"'";
        questionHTML += ');';
        
        questionHTML += '" disabled><br/>';
	}
	
	var answerDivHTML = '<div id="'+trainingAnswerDivID+'" style="display: none; padding-left: 0px; padding-top: 80px;">' + answerHTML;
	answerDivHTML += '<input id="traininganswerbutton" type="button" name="next" value="Next page" onClick="';
	if (checkNoOfCorrectAnswers){
        answerDivHTML += "if (passedTraining('"+imgdir+"', "+noOfTrainingQues+")){";
        answerDivHTML += "showSinglePage(";
        answerDivHTML += "'"+nextPageNoStr+"'";
        answerDivHTML += ');}';
        answerDivHTML += "else {document.getElementById('form').style.display = 'none'; document.getElementsByTagName('body')[0].innerHTML = 'Sorry, you cannot complete this job, as you got most of the training questions wrong.';}";
    } else {
        answerDivHTML += "showSinglePage(";
        answerDivHTML += "'"+nextPageNoStr+"'";
        answerDivHTML += ');';
    }
    answerDivHTML += '"> </div>';
    
    
	s += '<p><div style="float:left; padding-right:10px"><img alt="" width="650px" src =' + imageHTML + '></div></p>';	
    s += '<div style = "padding-top:15px; padding-bottom:0px;" />';
	s += '<div style="line-height: 160%;">' + textHTML + '</div>';
	s += '<div id="'+trainingChoicesDivID+'" style="line-height: 160%; display: inline-block; white-space: nowrap;" >' + questionHTML + '</div>';
	s += answerDivHTML;
    s += '</div>';

    return s;
}



function getHTMLforQuestion(imgdir, question, problemNo, noOfPages_total, saveAnswer) {
	var s = "";

    currentPageNoStr = getPageNoStr(currentPageNo);
    nextPageNoStr = getPageNoStr(currentPageNo+1);
    pageOutOfPages = getPageOutOfPages(noOfPages_total);
    
    var imgSuffix = ".png";
    choicesText = getChoices(questionRefName+'/','qc');  
    textHTML = getHTML(questionRefName+'/q.html');
    imageHTML = imgdir +'/'+question+imgSuffix;
    questionHTML = "Your answer: <br/>"   
    
    s += '<p>Page '+pageOutOfPages+'</p><hr>';    
    s += '<h3>Problem '+problemNo+'</h3>';
    s += '<p style="line-height:0.05;"><font color="#999999"><div id="problemmessage">Answer in 15sec, before next question is displayed. Timer (bottom right) indicates time left.</font></p>';
    s += '<div style="font-size:14px;" id="question'+problemNo+'">';
    
    for (var i  = 0; i<choicesText.length; i++) {
        buttonId = "button_"+currentPageNoStr+"_"+i;
        questionHTML += '<input type="button"  id="'+buttonId+'" name="'+question+'" value="'+choicesText[i]+'"';
        questionHTML += ' style="height:40px; width:60px; font-size: 12px; margin: 5px 5px; background-color:#EBEDEF; border:2; border-radius:10px;"';
        questionHTML += 'onClick="';
        questionHTML += "recordCorrectness('"+question+"a', '"+choicesText[i]+"'); ";
        if (saveAnswer){
            questionHTML += "saveQuestionAnswer('"+question+"a', '"+choicesText[i]+"'); ";
            questionHTML += "saveQuestionTime('"+question+"t', '"+currentPageNoStr+"'); ";
        }
        questionHTML += "showSinglePage(";
        questionHTML += "'"+nextPageNoStr+"'";
        questionHTML += ');';
        questionHTML += '" disabled><br/>';
	}

	
	s += '<p><div style="float:left; padding-right:10px"><img alt="" width="650px" src =' + imageHTML + '></div></p>';	
    s += '<div style = "padding-top:15px; padding-bottom:0px;" />';
	s += '<p><div style="line-height: 160%;">' + textHTML + '</div></p>';
	s += '<p><div style="line-height: 160%; display: inline-block; white-space: nowrap;" >' + questionHTML + '</div></p>';
    s += '</div>';

    return s;
}


function getHTMLforBreak(textpath, breakNo, noOfPages_total){
    var s = "";
    
    texthtml = getHTML(textpath);
    currentPageNoStr = getCurrentPageNoStr();
    nextPageNoStr = getPageNoStr(currentPageNo+1);
    pageOutOfPages = getPageOutOfPages(noOfPages_total);
    
    
    var correctStatsDivHTML = '<div id="'+(correctStatsDivID+breakNo)+'" style="display:none; padding-left: 0px; padding-top: 5px;"></div>';

    s += '<p>Page '+pageOutOfPages+'</p><hr>';
    s += texthtml;
    s += correctStatsDivHTML;
    s += '<br>'
    s += '<p>Are you ready to continue the job?</p>';
    s += '<input id="breakbutton" type="button" name="next" value="Next page" onClick="';
    s += "if (checkAllFields('"+currentPageNoStr+"')){";
    s += "if (isFinishedAndSpammer()){"
    s += "document.getElementById('form').style.display = 'none'; document.getElementsByTagName('body')[0].innerHTML = 'Sorry, job completion code cannot be granted to you, because you did not answer certain questions correctly and/or you got a very low percentage of correct answers.';";
    s += "} else {noOfBreakCompleted+=1; showSinglePage('"+nextPageNoStr+"');}";
    s += "} else alert('"+pageNotCompleteError+"');";
    s += '">';
    //s += '<font color="#999999"><div id="breakbuttonmessage">(you cannot return to this page afterwards)</font>';
    s += '<script type="text/javascript">if (DEBUG_showAllPages) document.write("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");</script>';
    
    return s;   
}


function getHTMLforQuestionnaire(textpath,noOfPages_total){
    var s = "";
    
    texthtml = getHTML(textpath);
    currentPageNoStr = getCurrentPageNoStr();
    nextPageNoStr = getPageNoStr(currentPageNo+1);
    pageOutOfPages = getPageOutOfPages(noOfPages_total);
    fieldNotRequired = "questionnaireComments";
    
    s += '<p>Page '+pageOutOfPages+'</p><hr>';
    s += texthtml;
    s += '<br/>';
    s += '<input type="submit" id="Submit" value="Submit" onClick="';
    s += "if (checkAllFieldsExcl('"+currentPageNoStr+"', '"+fieldNotRequired+"')){this.disabled=true; document.getElementById('timeSubmitted').value = ISODateString(new Date()); calculateTiming("+noOfPages_total+"); this.form.submit();} else {alert('"+pageNotCompleteError+"'); return false;}";
    s += '">';
    s += '<font color="#999999">(this will submit all pages)</font>';
    s += '<script type="text/javascript">if (DEBUG_showAllPages) document.write("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");</script>';
    
    return s;   
}



function getHTMLforCompletionCode(textpath, completioncode){
    var s = "";
    
    texthtml = getHTML(textpath);
    
    s += '<div style="font-family:Sans-Serif; font-size: 75%;">';
    s += texthtml;
    s += '<p style="font-size:14px;">'+completioncode+'</p>';
    s += '</div>';
    
    return s;   
}


//
// PRETEST
//
function passedPreTest(){
    pretestlimits = getChoices(pretestRefName+'/','pl');
    for (i=0; i<pretestlimits.length; i++){
        limit_values = pretestlimits[i].split(",");
        fieldname = limit_values[0];
        min = limit_values[1];
        max = limit_values[2];
        userinput = document.getElementById(fieldname).value;
        userinput_value = parseFloat(userinput)
        if (isNaN(userinput_value)){
            if ((userinput != min) && (userinput != max)){
                return false;
            }
        } else {
            if ((userinput_value < min) || (userinput_value > max)){
                return false;
            }
        }
    }
    return true;
}


//
// TRAINING / TEST QUESTIONS 
//
function passedTraining(path, noOfQues){
    
    /* 
    // based on the number of correct (no. of correct would be specified in training/tp.txt) 
    // rather then which is correct and what range of answers is acceptable 
    var noOfCorrectToPass = Number(getHTML(path + "/tp.txt").trim());
    var noOfCorrect = 0;
    for (i=1; i<=noOfQues; i++){
       var answer_user = document.getElementById("t"+i+"a").value;
       var answer_correct = Number(getHTML(path + "/t"+i+".txt").trim());
       if (answer_user == answer_correct){
            noOfCorrect += 1;
       }
    }
    return (noOfCorrect >= noOfCorrectToPass);
    */
    
    
    // based on which are correct and what range of answers is acceptable as specified in file tl.txt
    traininglimits = getChoices(trainingRefName+'/','tl');
    for (i=0; i<traininglimits.length; i++){
        limit_values = traininglimits[i].split(",");
        fieldname = limit_values[0]+"a";
        min = limit_values[1];
        max = limit_values[2];
        userinput = document.getElementById(fieldname).value;
        userinput_value = parseFloat(userinput)
        if (isNaN(userinput_value)){
            if ((userinput != min) && (userinput != max)){
                return false;
            }
        } else {
            if ((userinput_value < min) || (userinput_value > max)){
                return false;
            }
        }
    }
    return true;
}


//
// QUESTION SEQUENCE AND RELATED UTILITIES
//

function questionSequence(questionCount) {
	var ret = [];
	for (var i=0;i<questionCount;i++) { 
		var value = Math.floor((Math.random()*questionCount)+1);
		while(isInArray(ret,value)) {
			value = Math.floor((Math.random()*questionCount)+1);
		}
		ret[i] = value;
	}
	return ret;
}


function isInArray(array, a) {
	for (i=0;i<array.length;i++) {
		if(array[i] == a) {
			return true;
		}
	}
	return false;
}

function getChoices(path,choices){
	var txtSuffix = ".txt";

    var choicesString = getHTML(path + choices + txtSuffix);
    var choicesArray = choicesString.split("\n");
	return choicesArray;
}

function getCurrentPageNoStr(){
    return pagestr+currentPageNo;
}

function getPageNoStr(pageNo){
    return pagestr + pageNo;
}

function getPageOutOfPages(noOfPages_total){
    return currentPageNo+"/"+noOfPages_total;
}

function getValueToPercentage(value){
    return Math.round(value * 100);
}

function loadCorrectAnswersToQuestionsAndCatches(){
    correctAnswersToQuestions=getChoices(visRefName+'/','qa');
    correctAnswersToCatches=getChoices(catchRefName+'/','ca');
}


//
// SHOW ONE PAGE OR DIV
//
function showSinglePage(showPage) {
	//if(showPage != "page1")
	//{
	//	var page1 = document.getElementById('page1');
	//	var nextButt = document.getElementById("firstbutton");
	//	page1.removeChild(nextButt);
	//}
	
	var divBlockShow = document.getElementById(showPage);
	for(var i in pageArray) {
		var hidePage = pageArray[i];
		var divBlockHide = document.getElementById(hidePage);
		

		if (!DEBUG_showAllPages) {
			divBlockHide.style.display = "none";
		}
		else {
			divBlockHide.style.display = "block";
			divBlockHide.style.border = "none";
		}
		if (currentVisiblePages.indexOf(hidePage) > -1) {
			endTimes[hidePage] = new Date().getTime();
		}
	}


	// show the required page
	if (!DEBUG_showAllPages) {
		divBlockShow.style.display = "block";
	}
	else {
		divBlockShow.style.border="3px solid black";
	}
	startTimes[showPage] = new Date().getTime();
	currentVisiblePages = [showPage];
	
	nextPage = nextPageForPages[showPage];
	showTimerOnThisPage = showTimerOnPageForPages[showPage];
	
	setCountdownVisible(false);
	endCountdown();
	if (showTimerOnThisPage){
	    startCountdown(showPage, pageMaxTimeInSec, nextPage)
	}
	
	// enable all the buttons if there are any after a few msec
	if (pageHasMultiChoiceButtons[showPage]){
	    choicesText = getChoices(questionRefName+'/','qc'); 
	    setTimeout(function(){for(i=0;i<choicesText.length;i++){document.getElementById("button_"+showPage+"_"+i).disabled = false;}},600);
	}

	if (pageIsAProblemPage[showPage]){
	    noOfProblemsCompleted += 1;
	}
	
	// This adds a flicker, otherwise the user might not realize the page has changed
	// when they are similar.
	//setTimeout("showSinglePage(" + showPage + ");", 200);	
}

function showTrainingAnswer(divId, choicesId){
     document.getElementById(choicesId).style.display = "none";
     document.getElementById(divId).style.display = "inline-block";
}


//
// Compose completion code
//
function composeCompletionCode(){
    var uuid = generateUUID();
    var scode = getChoices(completioncodeRefName+'/','s');
    var suuid = uuid.split("-");
    var code = "";
    var j = 0;
    for (i=0; i<suuid.length; i++){
        code += (scode[j] + suuid[i] + scode[j+1] + "-");    
        j += 2;
    }
    return code;
}


//
// SAVE ANSWERS AND TIME FOR QUESTION
//


function isFinishedAndSpammer(){
    var allProblemsComputed = (noOfProblemsCompleted==totalNoOfProblems);
    var isFinishedAndSpammerRet = (allProblemsComputed && (inattentiveParticipant!=undefined) && inattentiveParticipant);
    if (allProblemsComputed && !inattentiveParticipant){
        completionCode = composeCompletionCode();
        document.getElementById("completionCode").value = completionCode;
        document.getElementById('completionCodeHTML').value = getHTMLforCompletionCode(completioncodeRefName+"/text.html",completionCode);
    }
    return isFinishedAndSpammerRet;
}

function wasParticipantInattentive(noOfCorrectQues, noOfCorrectCatches){
    return  ( ((noOfCorrectCatches/totalNoOfCatches) < lowestReliableTotalCatchCorrectness) || ((noOfCorrectQues/totalNoOfQues) < lowestReliableTotalQuesCorrectness) );
}

function enableCorrectStatsOnBreak(){
    
    var allProblemsComputed = (noOfProblemsCompleted==totalNoOfProblems);
    var displayCorrectStats = (((noOfBreakCompleted+1)==Math.round(totalNoOfBreaks/2)) || allProblemsComputed);
    var displayHTMLvalue = displayCorrectStats ? "inline-block" : "none"; 
    
    if (displayCorrectStats){
        var html = '<p style="color:red; line-height:1.5; font-size:18px;">'
        html += 'Correct Answers: '+noOfCorrectProblemsSoFar+'/'+noOfProblemsCompleted+' = '+getValueToPercentage(noOfCorrectProblemsSoFar/noOfProblemsCompleted)+'%<br>';
        html += 'Questions Left: '+(totalNoOfProblems-noOfProblemsCompleted)+'</p>';
        
        var div = document.getElementById(correctStatsDivID+(noOfBreakCompleted+1));
        div.innerHTML = html;
        div.style.display = "inline-block";
    
    } else {
        var div = document.getElementById(correctStatsDivID+(noOfBreakCompleted+1));
        div.style.display = "none";
    }
}

function recordCorrectness(question, answer){
    
    quesNo = parseInt(question.replace(/\D/g, ''));
    correctAnswer = undefined;
    if (question[0]=="q"){
        correctAnswer = correctAnswersToQuestions[quesNo-1]; // -1 because array index starts from 0  
        noOfCorrectQuesSoFar += ( (answer == correctAnswer) ? 1 : 0);  
    } else if (question[0]=="c"){
        correctAnswer = correctAnswersToCatches[quesNo-1]; // -1 because array index starts from 0  
        noOfCorrectCatchesSoFar += ( (answer == correctAnswer) ? 1 : 0);
    }
    if (correctAnswer != undefined){
        noOfCorrectProblemsSoFar += ( (answer == correctAnswer) ? 1 : 0);
    }
    
    if (noOfProblemsCompleted == totalNoOfProblems){
        inattentiveParticipant = wasParticipantInattentive(noOfCorrectQuesSoFar,noOfCorrectCatchesSoFar);
    }    
    
    enableCorrectStatsOnBreak();
    
}

function saveQuestionAnswer(question, answer){
    document.getElementById(question).value = answer;
} 

function saveQuestionTime (question, page){
    document.getElementById(question).value = calculateTimeOnPageInSecs(page);
}



//
// CALCULATE FINAL TIMING 
//
function calculateTiming(noOfPages_total) {
    
    // needed for the last page
	for(var i in pageArray) {
		var page = pageArray[i];
		if (startTimes[page] != 0 && endTimes[page] == 0) // will happen for the last page
			endTimes[page] = new Date().getTime();
	}

	// populate the values of the hidden time fields
	var jobCompletionTime = 0;
	for(var i in pageArray) {
		var page = pageArray[i];
		var timeField = document.getElementById('timeOn' + page);
		var timeThisPage = (endTimes[page] - startTimes[page]);
		timeField.setAttribute('value', timeThisPage / 1000.0);
		//console.log(timeThisPage);
		jobCompletionTime += timeThisPage;
	}
	var timeField = document.getElementById('timeOnpages1to'+noOfPages_total);
	timeField.setAttribute('value', jobCompletionTime / 1000.0);		
}

function calculateTimeOnPageInSecs(page){
    endTimes[page] = new Date().getTime();
    return(endTimes[page] - startTimes[page])/1000.0;
}


//
//  CHECK SOFTWARE AND HARDWARE APPROPRIATENESS
//

// Check device -> reject mobile devices and respective OS
// src: http://stackoverflow.com/questions/6666907/how-to-detect-a-mobile-device-with-javascript
function isDeviceAppropriate(){
    isAMobileDevice = (/Android|webOS|iPhone|iPad|iPod|BlackBerry|BB|PlayBook|IEMobile|Windows Phone|Kindle|Silk|Opera Mini/i.test(navigator.userAgent));
    return !isAMobileDevice;
}

// Check browser
function isBrowserAppropriate(){
    
    // brute force check for IE 8 or less
	try {
		var a = [1];
		var b = a.indexOf(0);
	} catch(err) {
		return false;
	}
    return true;
}


//
// SAVE CONTRIBUTOR ID AND CHECK WHETHER IT IS UNIQUE OR NOT
//

function saveContributorIDInField(){
    var id = document.getElementById('contributorID').value.trim();
    return saveContributorId(id);
}

function saveContributorId(id) {

	if (id=="") {
		return true;
	}
    
    id = id.trim();

	try {
		var request;
		if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
			xmlhttp=new XMLHttpRequest();
		} else {// code for IE6, IE5
			xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
		}

		xmlhttp.onreadystatechange=function() {
			if (xmlhttp.readyState==4 && xmlhttp.status==200) {
				return;
			}
		}
		xmlhttp.open("GET","saveIDs.php?nocache="+Math.random()+"&id="+id,false);
		xmlhttp.send();
			
	} catch (err) {
		if (window.XMLHttpRequest){ 
			try{
				request=new ActiveXObject("Microsoft.XMLHTTP");
				request.open("GET", "saveIDs.php?nocache="+Math.random()+"&id="+id,false);
				request.send();
				if (request.readyState==4 && request.status == 200) {
					return;
				}
			} catch (err) {
				return false;
			}
		} else {
	 		return false;
		}	
	}
	return true;
}

function isContributorIDInFieldUnique(){
    var id = document.getElementById('contributorID').value.trim();
    return isContributorUnique(id);
}

function isContributorUnique(id) {

    id = id.trim();
 
	var webpageURL = window.location.toString().substring(0,window.location.toString().lastIndexOf("/"));
	var idsURL = webpageURL+"/ids.txt"+"?nocache="+Math.random();
	
	var idString = getHTML(idsURL);
	var idArray = idString.split("\n");
	
	for (var i = 0; i < idArray.length; i++) {
		var savedId = idArray[i];
		if(id == savedId) {
			return false;
		}
	}
	return true;		
}








