"""
Functions to plot parallel coordinates depicting the data in the log files

Author: Luana Micallef, December 2015
"""


import pandas
import matplotlib
import matplotlib.pyplot as plt
from pandas.tools.plotting import parallel_coordinates

import os, glob


def getAllLogFileNames(dirpath):
    os.chdir(dirpath)
    filenames = glob.glob("*.log")
    return filenames


def generateParallelCoordinatePlot(datafilepath, plotfilepath, includeObjScore):

    matplotlib.style.use('ggplot')

    colsToInclude = ['n_incumbent','overlapFactor','overplottingFactor','lightnessFactor','meanFactor','contrastFactor']
    #'axis_actual_foreachcluster','angle_actual_foreachcluster','axis_perceived_foreachcluster','angle_perceived_foreachcluster','axis_error_foreachcluster','angle_error_foreachcluster','overlapFactor_foreachcluster','overplottingFactor_foreachcluster','lightnessFactor_foreachcluster','meanFactor_foreachcluster','contrastFactor_foreachcluster','overlapFactor','overplottingFactor','lightnessFactor','meanFactor','contrastFactor']
    if (includeObjScore):
        colsToInclude.append('objective_score')
    
    sampdata = pandas.read_csv(datafilepath, sep='|', comment='T', usecols=colsToInclude)
    
    ax = parallel_coordinates(sampdata, 'n_incumbent', linewidth=0.8, colormap='gist_rainbow')
    ax.set_axis_bgcolor('white')
    ax.legend(loc='center left', bbox_to_anchor=(1, 0.5), title='incumbents')
    plt.xticks(rotation=90)
    
    termreason = ((pandas.read_csv(datafilepath, sep='|', usecols=['n_incumbent']))[-1:]).get_values()[0][0]
    plt.text(0, -1, termreason, fontsize=8)
    
    fig = ax.get_figure()
    fig.savefig(plotfilepath, bbox_inches='tight')
    
    plt.cla()
    plt.clf()
    
    return
    

def generatePlotsForAllLogFiles():
    
    #optimizedplotfilesdir = ".." + os.path.sep + "optimizedplots" + os.path.sep + "evalruns"  + os.path.sep + "imgwidth500_using5ImageMetrics"
    optimizedplotfilesdir = ".." + os.path.sep + "optimizedplots" + os.path.sep + "20160307_randomsearch"
    os.chdir(optimizedplotfilesdir)
    logplotsdir = "logplots" 
    
    logfilenames = getAllLogFileNames('.')
    
    for fn in logfilenames:
        logfilepath = fn
        logplotfilepath_woObjScore = (logplotsdir + os.path.sep + fn).replace(".log",".pdf")
        logplotfilepath_wObjScore = (logplotsdir + os.path.sep + fn).replace(".log","_wobjscore.pdf")
        
        generateParallelCoordinatePlot(logfilepath, logplotfilepath_woObjScore, False)  
        generateParallelCoordinatePlot(logfilepath, logplotfilepath_wObjScore, True)    
        
    return
    


generatePlotsForAllLogFiles()