"""
The main script that runs the model-based scatterplot optimization system 

Authors: Luana Micallef, Antti Oulasvirta, Tino Weinkauf, Gregorio Palmas, August 2015
"""


import os 
from scatterplotimage import ScatterPlotter
#import clustering
import model
import utilities
import colors
import optimizers
import plottingintermdata
import sys
import numpy as np
from scipy import stats
import itertools



# Data csv files, optimized plot image files, and temp directories
dataFilesDir = ".." + os.path.sep + "data" + os.path.sep + "studydata/outliers" #"studydata/corr" #"studydata/clusters" #"wClusterIDwOutliers" 
#dataFilesDir = ".." + os.path.sep + "data" + os.path.sep + "study2Data/clusters" #"study2Data/outliers" #"study2Data/corr" #"study2Data/clusters" 


optimizedplotFilesDir = ".." + os.path.sep + "optimizedplots"
tempDir = "temp"
tempDataFilesDir = tempDir + os.path.sep + "data"
tempImageplotFilesDir = tempDir + os.path.sep + "imageplots"
datapointsClusterFilePath_norunid = tempDataFilesDir + os.path.sep + "dpcluster_temp.csv" 
factorsTempFilePath_norunid = tempDataFilesDir + os.path.sep + "factors_temp.csv"
measuresTempFilePath_norunid = tempDataFilesDir + os.path.sep + "goodnessmeasures_temp.csv"

# Input data and output image plot file names and file paths 
#dataFileNames = ["randNorm_0.25corr_1000pnts.csv", "randNorm_0.5corr_1000pnts.csv", "randNorm_0.75corr_1000pnts.csv", "randNorm_1corr_1000pnts.csv", "randNorm_0.25corr_100pnts.csv", "randNorm_0.5corr_100pnts.csv", "randNorm_0.75corr_100pnts.csv", "randNorm_1corr_100pnts.csv"]
#dataFileNames = ["randNorm_1000pnts_1clusters_4.csv"]
#dataFileNames = [ "randNorm_100pnts_1clusters.csv","randNorm_500pnts_1clusters.csv","randNorm_1000pnts_1clusters.csv","randNorm_10000pnts_1clusters.csv", \
#                  "randNorm_1000pnts_2clusters.csv","randNorm_1000pnts_3clusters.csv","randNorm_1000pnts_4clusters.csv","randNorm_1000pnts_5clusters.csv","randNorm_10000pnts_5clusters.csv"]
#dataFileNames = ["randNorm_1000pnts_4clusters_0.csv","randNorm_1000pnts_5clusters_1.csv","randNorm_100pnts_4clusters_3.csv","randNorm_100pnts_5clusters_3.csv",\
#                "randNorm_10000pnts_5clusters_3.csv", "randNorm_10000pnts_5clusters_2.csv"]
dataFileNames = ["randNorm_10000pnts_1clusters_3.csv"]
#dataFileNames = utilities.getFileNamesFromDir(dataFilesDir,"csv")


#chosen datafiles for outliers task
#dataFileNames = ["randNorm_100pnts_1clusters_1.csv", "randNorm_100pnts_1clusters_4.csv", "randNorm_100pnts_1clusters_3.csv", "randNorm_100pnts_1clusters_2.csv",
#                 "randNorm_1000pnts_1clusters_2.csv", "randNorm_1000pnts_1clusters_3.csv", "randNorm_1000pnts_1clusters_5.csv", "randNorm_1000pnts_1clusters_1.csv",
#                 "randNorm_10000pnts_1clusters_2.csv", "randNorm_10000pnts_1clusters_5.csv", "randNorm_10000pnts_1clusters_3.csv", "randNorm_10000pnts_1clusters_1.csv"]

#data for intro outliers
#dataFileNames = ["randNorm_10000pnts_1clusters_5_train.csv"]

#data for train outliers
#dataFileNames = ["randNorm_1000pnts_1clusters_1_train.csv", "randNorm_1000pnts_1clusters_2_train.csv"] #easy train, smooth with out. perc.
#dataFileNames = ["randNorm_10000pnts_1clusters_4_train.csv"] #more difficult train first data:small dots
#dataFileNames = ["randNorm_1000pnts_1clusters_5_train.csv"] #more difficult train secon data: smooth var
#
#dataFileNames = ["randNorm_10000pnts_1clusters_0_catch.csv"] #for catch, smooth with out. perc.

#data for intro clusters
#dataFileNames = ["randNorm_1000pnts_5clusters_intro_clusters.csv"] 


# Discretized visual variables (design space)
marker_sizes = np.linspace(3, 53, 21) # agreed upon on Jan 6
# marker_sizes = [2.5, 5.0, 7.5, 10.0, 12.5, 15.0, 17.5, 20.0, 22.5, 25.0] # greater than those agreed on Sep 8
# marker_sizes = [0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0] # agreed on Sep 8
marker_opacities = np.linspace(5, 255, 21) #agreed upon on Jan 6
image_widths = [1000] #agreed upon Jan 6
#image_aspect_ratios = [0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5]

image_aspect_ratios = [1] #for correlation and for outliers


#design space for isabel

#marker_sizes = np.linspace(1, 30, 30)
#marker_opacities = np.linspace(1, 121, 41)
#image_widths = [900]
#image_aspect_ratios = [1.6]

#image_aspect_ratios = np.linspace(0.20, 0.5, 10) #for clusters intro

#design space for correlation task 2
#image_widths = [650.]
#image_aspect_ratios = [1.]
#image_aspect_ratios = [0.5]
#image_aspect_ratios = [2.]

#marker_sizes = np.linspace(3, 53, 10)
#marker_opacities = np.linspace(5, 255, 10)
#image_widths = [1000]
#image_aspect_ratios = np.linspace(0.5, 1.5, 5)#[0.5, 1, 1.5]
#image_aspect_ratios = [0.5, 1, 1.5]
#image_aspect_ratios = [1]



# Use the following when plotting just one design
#marker_sizes=[10]
#marker_opacities=[155]
#image_widths = [1000]
#image_aspect_ratios=[1]

#marker_sizes=[53]
#marker_opacities=[230]
#image_widths = [1000]
#image_aspect_ratios=[1]


### Design space used for creating the weight sets of the correlation task ###

#marker_sizes=[5, 20, 40]
#marker_opacities=[4, 50, 100, 255]
#image_widths = [1000]
#image_aspect_ratios=np.linspace(0.5, 1.5, 5)#[0.5, 1.0, 1.5]

### Design from Ronald Rensik ###
#http://stackoverflow.com/questions/139655/convert-pixels-to-points and
#https://www.w3.org/TR/CSS21/syndata.html#x39 for converting points to pixels
#it is points  = 72/pic.dpi * pixels, in out case pic.dpi is 72, so 1point = 1pixel

#marker_sizes=[2]
#marker_opacities=[255]
#image_widths = [300]
#image_aspect_ratios=[1.0]


#all the weight sets had total_angle_error, total_axis_error and totalSDySDxRatio_error set to 0 for the correlation task

"""
    Classic scatter plot with almost black, almost fully opaque, small dots.
    We prefer darker images (lightnessfactor).
"""
Weights_CorrelationSmallDots = np.array(
                    [
                        1, #total_angle_error,
                        2, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                        1, #overlapFactor,
                        0, #overplottingFactor,
                        2, #lightnessFactor,
                        1, #meanFactor,
                        1, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )

"""
    Variation: Ignore other image metrics such as contrast and mean. Just go for black pixels.
    This makes the dots a bit larger.
"""
Weights_CorrelationSmallDotsVar1 = np.array(
                    [
                        1, #total_angle_error,
                        2, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                        1, #overlapFactor,
                        0, #overplottingFactor,
                        2, #lightnessFactor,
                        0, #meanFactor,
                        0, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )

"""
    This is a design with very smooth results. All dots merge into each other.
    We deem this interesting for a large number of points, to identify the main trend = correlation.
"""
Weights_CorrelationSmooth = np.array(
                    [
                        1, #total_angle_error,
                        2, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                       -1, #overlapFactor,
                        1, #overplottingFactor,
                        0, #lightnessFactor,
                        1, #meanFactor,
                        1, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )
"""
    Variation: Lighter version
"""
Weights_CorrelationSmoothVar1 = np.array(
                    [
                        1, #total_angle_error,
                        2, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                       -1, #overlapFactor,
                        1, #overplottingFactor,
                       -1, #lightnessFactor,
                        1, #meanFactor,
                        1, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )

"""
    Variation: Darker version, but also incurs more overplotting
"""
Weights_CorrelationSmoothVar2 = np.array(
                    [
                        1, #total_angle_error,
                        2, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                       -1, #overlapFactor,
                        1, #overplottingFactor,
                        1, #lightnessFactor,
                        1, #meanFactor,
                        1, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )

"""
    Variation: Darker version, with less overplotting
"""
Weights_CorrelationSmoothVar3 = np.array(
                    [
                        1, #total_angle_error,
                        2, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                       -1, #overlapFactor,
                        2, #overplottingFactor,
                        1, #lightnessFactor,
                        1, #meanFactor,
                        1, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )

"""
    Utility weights only with correlation terms set to 1
"""
Weights_CorrelationOnly = np.array(
                    [
                        1, #total_axis_error,
                        2, #total_angle_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                        0, #overlapFactor,
                        0, #overplottingFactor,
                        0, #lightnessFactor,
                        0, #meanFactor,
                        0, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )

"""
    Weights to get plots with medium opaque points
"""

Weights_ClusterMediumDots = np.array(
                    [
                        1, #total_axis_error,           
                        2, #total_angle_error,          
                        0, #totalSDySDxRatio_error,     
                        0, #total_direction_error,      
                        0, #total_perceived_bbox_error, 
                        2, #overlapFactor,              
                       -1, #overplottingFactor,         
                        0, #lightnessFactor,            
                        0, #meanFactor,                 
                       -1, #contrastFactor,             
                        1, #ClusterPerceivability,      
                        0, #OutliersPerceivability      
                    ]
                    )

#Weights to get plots with large opaque points
Weights_ClusterBlobs = np.array(
                    [
                        1, #total_axis_error,           
                        2, #total_angle_error,          
                        0, #totalSDySDxRatio_error,     
                        0, #total_direction_error,      
                        0, #total_perceived_bbox_error, 
                       -1, #overlapFactor,              
                        0, #overplottingFactor,         
                        1, #lightnessFactor,            
                        0, #meanFactor,                 
                       -1, #contrastFactor,             
                        1, #ClusterPerceivability,      
                        0, #OutliersPerceivability      
                    ]
                    )

"""
    Variation: Darker version, but also incurs more overplotting
"""
Weights_ClusterSmoothVar2 = np.array(
                    [
                        1, #total_angle_error,
                        2, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                       -1, #overlapFactor,
                        1, #overplottingFactor,
                        1, #lightnessFactor,
                        1, #meanFactor,
                        1, #contrastFactor,
                        1, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    )


"""
    Outliers perc only
"""
Weights_OutliersPercOnly = np.array(
                    [
                        0, #total_axis_error,
                        0, #total_angle_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                        0, #overlapFactor,
                        0, #overplottingFactor,
                        0, #lightnessFactor,
                        0, #meanFactor,
                        0, #contrastFactor,
                        0, #ClusterPerceivability,
                        1, #OutliersPerceivability
                    ]
                    )

"""
    Variation: Lighter version
"""
Weights_OutliersSmoothVar1 = np.array(
                    [
                       0, #total_angle_error,
                       0, #total_axis_error,
                       0, #totalSDySDxRatio_error,
                       0, #total_direction_error,
                       0, #total_perceived_bbox_error,
                      -1, #overlapFactor,
                       1, #overplottingFactor,
                       0, #lightnessFactor,
                       1, #meanFactor,
                       1, #contrastFactor,
                       0, #ClusterPerceivability,
                       0, #OutliersPerceivability
                    ]
                    ).astype(np.float64)


"""
    Variation: Lighter version with outlier perceivability
"""
Weights_OutliersSmoothVar1_OPerc = np.array(
                    [
                       0, #total_angle_error,
                       0, #total_axis_error,
                       0, #totalSDySDxRatio_error,
                       0, #total_direction_error,
                       0, #total_perceived_bbox_error,
                      -1, #overlapFactor,
                       1, #overplottingFactor,
                       0, #lightnessFactor,
                       1, #meanFactor,
                       1, #contrastFactor,
                       0, #ClusterPerceivability,
                       2, #OutliersPerceivability #tuned to 5 for bank-full_balance_campaign_4out_converted and shock_dbp_rci_2out_converted
                    ]
                    ).astype(np.float64)


"""
    Variation: Lighter version
"""
Weights_OutliersSmallDots = np.array(
                    [
                        0, #total_angle_error,
                        0, #total_axis_error,
                        0, #totalSDySDxRatio_error,
                        0, #total_direction_error,
                        0, #total_perceived_bbox_error,
                        1, #overlapFactor,
                        0, #overplottingFactor,
                        2, #lightnessFactor,
                        1, #meanFactor,
                        1, #contrastFactor,
                        0, #ClusterPerceivability,
                        0, #OutliersPerceivability
                    ]
                    ).astype(np.float64)

# Choose one!
#Weights = Weights_CorrelationSmallDots
#Weights = Weights_
#Weights = Weights_CorrelationSmoothVar2

#Weights = Weights_CorrelationOnly
#Weights = Weights_CorrelationSmoothVar1

#WeightsArray = [Weights_CorrelationOnly]
#WeightsArrayNames = ["Weights_CorrelationOnly"]


#Weights = np.ones_like(Weights_CorrelationSmallDots) #All weighted the same!

#Weights = np.divide(Weights, np.linalg.norm(Weights))







#### Weight sets for the correlation task ####
#WeightsArray = [np.divide(Weights_CorrelationSmallDots, np.linalg.norm(Weights_CorrelationSmallDots)), \
#                np.divide(Weights_CorrelationSmoothVar1, np.linalg.norm(Weights_CorrelationSmoothVar1)), \
#                np.divide(Weights_CorrelationSmoothVar2, np.linalg.norm(Weights_CorrelationSmoothVar2))]
#WeightsArrayNames = ["Weights_CorrelationSmallDots", "Weights_CorrelationSmooth", "Weights_CorrelationSmoothVar2"]

#### Weight sets for the correlation task 2 with different aspect ratios####
#WeightsArray = [np.divide(Weights_CorrelationSmoothVar2, np.linalg.norm(Weights_CorrelationSmoothVar2))]
#WeightsArrayNames = ["Weights_CorrelationSmoothVar2"]


#### Weight sets for the cluster task ####
#WeightsArray = [np.divide(Weights_ClusterMediumDots, np.linalg.norm(Weights_ClusterMediumDots)), \
#                np.divide(Weights_ClusterBlobs, np.linalg.norm(Weights_ClusterBlobs)), \
#                np.divide(Weights_ClusterSmoothVar2, np.linalg.norm(Weights_ClusterSmoothVar2))]
#WeightsArrayNames = ["Weights_ClusterMediumDots", "Weights_ClusterBlobs", "Weights_ClusterSmoothVar2"]

#### Weight sets for the outliers task ####
#WeightsArray = [np.divide(Weights_OutliersSmoothVar1, np.linalg.norm(Weights_OutliersSmoothVar1)), \
#                np.divide(Weights_OutliersSmallDots, np.linalg.norm(Weights_OutliersSmallDots)), \
#                np.divide(Weights_OutliersSmoothVar1_OPerc, np.linalg.norm(Weights_OutliersSmoothVar1_OPerc))]
#WeightsArrayNames = ["Weights_OutliersSmoothVar1", "Weights_OutliersSmallDots", "Weights_OutliersSmoothVar1_OPerc"]



#winner weight for correlation, used for eval study
#WeightsArray = [Weights_CorrelationSmoothVar2]
#WeightsArrayNames = ["Weights_CorrelationSmoothVar2"]

#winner weight for outliers, used for eval study
#WeightsArray = [np.ones_like(Weights_OutliersSmoothVar1_OPerc)]
#WeightsArrayNames = ["Weights_OutliersSmoothVar1_OPerc"]

#winner weight for clusters, used for eval study
#WeightsArray = [Weights_ClusterBlobs]
#WeightsArrayNames = ["Weights_ClusterBlobs"]

#used for isabel
WeightsArray = [Weights_CorrelationSmoothVar2, Weights_OutliersSmoothVar1_OPerc]
WeightsArrayNames = ["Weights_CorrelationSmoothVar2", "Weights_OutliersSmoothVar1_OPerc"]





#WeightsArray = [np.ones_like(Weights_CorrelationSmoothVar2)]
#WeightsArrayNames = ["AllOnes"]






# Visual differences (delta E) between 9 (ideally, an n x n number) distinct CIE Lab colors to be later assigned to the clusters
#colorDeltas = colors.getDeltaEBetweenNDistinctLabColorsViaLCH(5) #12 30 degrees differences between hues
#colorDeltas = colors.getDeltaEBetween4or8DistinctLabColors(8)
#colorDeltas = colors.getDeltaEBetweenCategoricalDistinctColors()
colorDeltas = colors.getDeltaEBetweenCategoricalColorBrewerColors() # decided to use this with colorbrewer for 5 sets on 9th March 2016

# Info about visual variables and designs to be evaluated
max_marker_size = max(marker_sizes)
max_number_of_designs = len(marker_sizes) * len(marker_opacities) * len(image_widths) * len(image_aspect_ratios) #len(image_aspect_ratios) 

# Settings
# ... set searchTypes to none when plotting one design
searchTypes = ["exhaustive", "random", "none"]   
selectedSearch = searchTypes[0]
bSavePlotWithAxes = False # kept constant
plotIntermData = True  # for TESTING  

# For RANDOM SEARCH only: number of repetitions for the same data set points
number_of_repetitions = 4 #4

# For EXHAUSTIVE SEARCH only (or No search): all possible designs as a cartesian product of discretized visual variables 
allDesigns = None
if ((selectedSearch==searchTypes[0]) or (selectedSearch==searchTypes[2])):
    allDesigns = list(itertools.product(marker_sizes,marker_opacities,image_widths,image_aspect_ratios))


# Details to be logged for each optimized design that is found
log_headers = "start_datetime|end_datetime|max_marker_size|marker_size|marker_opacity|image_width|image_aspect_ratio|axis_actual_foreachcluster|angle_actual_foreachcluster|SDySDxRatio_actual_foreachcluster|axis_perceived_foreachcluster|angle_perceived_foreachcluster|SDySDxRatio_perceived_foreachcluster|axis_error_foreachcluster|angle_error_foreachcluster|unit_error_foreachcluster|SDySDxRatio_actualperceived_diff_foreachcluster|SDySDxRatio_error_foreachcluster|direction_error_foreachcluster|perceived_bbox_error_foreachcluster|overlapFactor_foreachcluster|overplottingFactor_foreachcluster|lightnessFactor_foreachcluster|meanFactor_foreachcluster|contrastFactor_foreachcluster|overlapFactor|overplottingFactor|lightnessFactor|meanFactor|contrastFactor|ClusterPerceivability|OutliersPerceivability|objective_score|noOfClusters\n"
if (selectedSearch==searchTypes[0]):
    log_headers = "n_incumbent|n_iters_overall|maxNoOfDesigns|" + log_headers
elif (selectedSearch==searchTypes[1]):    
    log_headers = "n_incumbent|n_iters_overall|n_iters_without_improvement|max_iters_without_improvement|" + log_headers


# Maximum number of cluster that we assume set of data points will have
#maxClusters = 4
    

# Get a scatter plotter
SP = ScatterPlotter(max_marker_size)

# Find an optimized scatterplot for each set of data points in the dataFileNames files
for dataFileName in dataFileNames:

    #if "clusters_0" in dataFileName or "clusters_8" in dataFileName:
    #    continue
    #if "100pnts" not in dataFileName and "1000pnts" not in dataFileName and "10000pnts" not in dataFileName:
    #    continue

    # ***************************************
    #  DATA part
    # *************************************** 

    # Load data points from csv file and cluster the data points
    dataFilePath = dataFilesDir + os.path.sep + dataFileName

    datapoints, datapointsClusters, datapointsClusters_woOutliers, \
    outliers_foreachcluster, corr_perCluster = \
            utilities.getDataPointsWithClustersFromCSVFile(dataFilePath, hasHeading=True, shuffle=False)
    
    DataBoundingBox = utilities.getBBox(datapoints)
    #datapointsClusters = {0:datapoints}
    #datapointsClusters = clustering.clusterDataPoints(datapoints, maxK=maxClusters)  # use this to detect the number of clusters in the data points
    TriangleIndices = np.stack(np.triu_indices(len(datapointsClusters), 1), axis=-1)
     
     
    # Compute covariance ellipse and its properties for each actual data points cluster
    clustersMeasures = {}
    actualCovEllipses = {}
    #actualCorrelations = {}
    actualSDySDxRatios = {}
    for d in range(0,len(datapointsClusters)):
        datapointsCluster = datapointsClusters[d]
        actual_covellipse, actual_minorOnMajorAxis, actual_angle = model.getDataCovarianceEllipse(datapointsCluster)
        clustersMeasures[d] = (actual_minorOnMajorAxis, actual_angle) 
        actualCovEllipses[d] = actual_covellipse
        #actualCorrelations[d] = stats.pearsonr(datapointsCluster[:,0], datapointsCluster[:,1])[0]
        actualSDySDxRatios[d] = model.getSDySDxRatioOfPointCloud(datapointsCluster)
        
    # Compute the cluster overlap measure for each pair of clusters
    actualPairwiseClusterOverlapMeasures, actualCovEllipsesOverlapAreas = model.getPairwiseClusterOverlapMeasures(actualCovEllipses, datapointsClusters, TriangleIndices)
   
    # Compute rendering order of clusters
    datapoints, \
    datapointsClusters, \
    outliers_foreachcluster, \
    actualPairwiseClusterOverlapMeasures_relabelled, \
    clustersMeasures_relabelled, \
    actualCovEllipses_relabelled, \
    actualSDySDxRatios_relabelled = model.getRenderingOrderOfClusters(datapoints, \
                                                                      datapointsClusters, \
                                                                      outliers_foreachcluster, \
                                                                      actualPairwiseClusterOverlapMeasures, \
                                                                      clustersMeasures, \
                                                                      actualCovEllipses, \
                                                                      actualSDySDxRatios, \
                                                                      TriangleIndices)
    
    # Get distinguishable RGB colors for clusters
    # Each color is a tuple of the form (r,g,b) where each of r, g and b values is in [0,1]
    color_foreachcluster = colors.getRGBColorsForClusters(actualPairwiseClusterOverlapMeasures_relabelled, colorDeltas, TriangleIndices)          
    
    # Plotting the actual data points and corresponding cluster ovariance ellipses for TESTING only 
    # this must be placed here, just after the order of the cluster rendering is finalized, otherwise the colors would be inconsistent with the once of the perceived
    if (plotIntermData):
        plottingintermdata.plotActualDataPointsAndClusterCovEllipses(datapointsClusters, actualCovEllipses_relabelled, dataFileName)  # for TESTING only

    
    
    print "\n******"+dataFileName+"******\n"
    
    
    # ***************************************
    #  DESIGN part
    # ***************************************
   
    for i in range(len(WeightsArray)):

        Weights = WeightsArray[i]
        WeightsName = WeightsArrayNames[i]

        # Output image plot file names and file paths 
        scatterplotImageFileName = None #dataFileName.replace(".csv","_"+runid+".png")
        scatterplotImageFilePath = None #tempImageplotFilesDir + os.path.sep + scatterplotImageFileName 
        if (plotIntermData):
            scatterplotImageFileName = dataFileName.replace(".csv",".png") # for TESTING only
            scatterplotImageFilePath = tempImageplotFilesDir + os.path.sep + scatterplotImageFileName  # for TESTING only   
        winningplotFilePath = optimizedplotFilesDir + os.path.sep + WeightsArrayNames[i] + os.path.sep + dataFileName.replace(".csv",".png")
        logFilePath = winningplotFilePath.replace(".png","_log.log")
        warningsFilePath = winningplotFilePath.replace(".png","_warnings.txt")
   
        
        if (selectedSearch==searchTypes[0]):
            # Optimization loop for EXHAUSTIVE SEARCH
            optimizers.exhaustiveSearch(allDesigns,max_marker_size,max_number_of_designs,DataBoundingBox,datapointsClusters,color_foreachcluster,datapoints,
                                            outliers_foreachcluster, clustersMeasures_relabelled,actualCovEllipses_relabelled,actualSDySDxRatios_relabelled,SP,bSavePlotWithAxes,dataFileName,scatterplotImageFilePath,winningplotFilePath,
                                            warningsFilePath,logFilePath,log_headers,plotIntermData,TriangleIndices, Weights, False)
        
        elif (selectedSearch==searchTypes[1]):
            # Optimization loop for RANDOM SEARCH
            optimizers.randomSearch(number_of_repetitions,marker_sizes,marker_opacities,image_widths,image_aspect_ratios,max_marker_size,
                                    max_number_of_designs,DataBoundingBox,datapointsClusters,color_foreachcluster,datapoints, outliers_foreachcluster, 
                                    clustersMeasures_relabelled,actualCovEllipses_relabelled,actualSDySDxRatios_relabelled,SP,bSavePlotWithAxes,dataFileName,scatterplotImageFilePath,winningplotFilePath,
                                    warningsFilePath,logFilePath,log_headers,plotIntermData,TriangleIndices, Weights, True)

        else:
            # Generate the plot with the first possible design
            for design in allDesigns:
                optimizers.PlotWinner(design, None, winningplotFilePath, "", datapointsClusters, datapoints, color_foreachcluster, SP, DataBoundingBox)
        
        
        
        
        