import Tkinter as tk
from Tkinter import *
import tkFileDialog

import numpy as np


class WeightDialog:

    def applyWeigths(self):
        
        weights  = self.GetWeights()
        
        [marker_size, marker_opacity, aspect_ratio, img_width] = self.view.EvalWeights(weights)

        self.SetValueToSBox(self.SizeSbox, marker_size)
        self.SetValueToSBox(self.OpacitySbox, marker_opacity)
        self.SetValueToSBox(self.RatioSbox, aspect_ratio)
        self.SetValueToSBox(self.WidthSbox, img_width)

    def saveWeigths(self):
        
        weights  = self.GetWeights()
        
        options = {}
        options['defaultextension'] = '.weights '
        options['filetypes'] = [('weights ', '.weights ')]
        options['initialdir'] = './'
        options['parent'] = self.tkobj
        options['title'] = 'Save Weights'

        file = tkFileDialog.asksaveasfile(mode = 'w', **options)

        if file == None:
            return

        np.savetxt(file.name, weights, delimiter = ",", comments = "")

    def loadWeights(self):
        
        options = {}
        options['defaultextension'] = '.weights'
        options['filetypes'] = [('weights', '.weights')]
        options['initialdir'] = './'
        options['parent'] = self.tkobj
        options['title'] = 'Load Weights'

        file = tkFileDialog.askopenfile(mode = 'r', **options)

        if file == None:
            return

        weights = np.genfromtxt(file.name, delimiter = ",")
        self.SetWeightsInSbox(weights)

        self.applyWeigths()

    def GetDesign(self):

        return [float(self.SizeSbox.get()), float(self.OpacitySbox.get()), float(self.RatioSbox.get()), float(self.WidthSbox.get())]

    
    def applyDesign(self):
        design = self.GetDesign()
        self.view.UpdatePlot(design)


    def saveDesign(self):
        
        design = self.GetDesign()
        
        options = {}
        options['defaultextension'] = '.design '
        options['filetypes'] = [('design ', '.design ')]
        options['initialdir'] = './'
        options['parent'] = self.tkobj
        options['title'] = 'Save Design'

        file = tkFileDialog.asksaveasfile(mode = 'w', **options)

        if file == None:
            return

        np.savetxt(file.name, design, delimiter = ",", comments = "")

    
    def loadDesign(self):
        
        options = {}
        options['defaultextension'] = '.design'
        options['filetypes'] = [('design', '.design')]
        options['initialdir'] = './'
        options['parent'] = self.tkobj
        options['title'] = 'Load Design'

        file = tkFileDialog.askopenfile(mode = 'r', **options)

        if file == None:
            return

        design = np.genfromtxt(file.name, delimiter = ",")
        
        
        self.SetDesignInSbox(design)

        self.applyDesign()


    def SetWeightsInSbox(self,weights):

        for i,sbox in enumerate(self.weightsSbox):
            self.SetValueToSBox(sbox, weights[i])


    def SetDesignInSbox(self, design):

        self.SetValueToSBox(self.SizeSbox, design[0])
        self.SetValueToSBox(self.OpacitySbox, design[1])
        self.SetValueToSBox(self.RatioSbox, design[2])
        self.SetValueToSBox(self.WidthSbox, design[3])


    def GetWeights(self):

        weights  = []
        for sbox in self.weightsSbox:
            weights.append(float(sbox.get()))

        weigths = np.array(weights)
        return weights


    def SetValueToSBox(self, sbox, value):

        sbox.delete(0,"end")
        sbox.insert(0, str(value))


    def __init__(self, view):

        #"SDySDxRatio","Direction"
        self.weights = ["Axis", "Angle", "Overlap","Overplot","Lightness","Mean","Contrast","ClusterPerc","OutliersPerc"]
        self.weightsSbox = []
        self.view = view
        viewDes = self.view.defaultDesign

        self.tkobj = Tk()
        i = 0
        self.lframe = LabelFrame(self.tkobj, text = "Weights")
        self.lframe.pack(fill="both", expand="yes")

        for weight in self.weights:
            self.label = Label(self.lframe, text=weight)
            self.label.grid(row = i, column = 0)
            self.labelSbox = Spinbox(self.lframe, from_=-99, to=99, format="%.2f", increment = 0.5, command = self.applyWeigths)
            self.weightsSbox.append(self.labelSbox)
            self.labelSbox.grid(row = i, column = 1)
            i += 1


        self.weightsButtonFrame = Frame(self.tkobj)
        
        self.applyWeights = tk.Button(self.weightsButtonFrame, text ="Apply", command = self.applyWeigths)
        self.applyWeights.grid(row = 0, column = 0)
        self.saveWeights = tk.Button(self.weightsButtonFrame, text ="Save Weigths", command = self.saveWeigths)
        self.saveWeights.grid(row = 0, column = 1)
        self.loadWeights = tk.Button(self.weightsButtonFrame, text ="Load Weights", command = self.loadWeights)
        self.loadWeights.grid(row = 0, column = 2)

        self.weightsButtonFrame.pack()

        self.lframeDes = LabelFrame(self.tkobj, text = "Design")
        self.lframeDes.pack(fill="both", expand="yes")

        self.labelSize = Label(self.lframeDes, text="MarkerSize")
        self.labelSize.grid(row = 0, column = 0)
        self.SizeSbox = Spinbox(self.lframeDes, from_=0, to=10000, command = self.applyDesign)
        self.SetValueToSBox(self.SizeSbox, viewDes[0])
        self.SizeSbox.grid(row = 0, column = 1)
        

        self.labelOpacity = Label(self.lframeDes, text="MarkerOpacity")
        self.labelOpacity.grid(row = 1, column = 0)
        self.OpacitySbox = Spinbox(self.lframeDes, from_ = 0, to = 255, command = self.applyDesign)
        self.SetValueToSBox(self.OpacitySbox, viewDes[1])
        self.OpacitySbox.grid(row = 1, column = 1)

        self.labelRatio = Label(self.lframeDes, text="AspectRatio")
        self.labelRatio.grid(row = 2, column = 0)
        self.RatioSbox = Spinbox(self.lframeDes, from_ = 0.1, to = 99, format="%.2f", increment = 0.1, command = self.applyDesign)
        self.SetValueToSBox(self.RatioSbox, viewDes[2])
        self.RatioSbox.grid(row = 2, column = 1)

        self.labelWidth = Label(self.lframeDes, text="PlotWidth")
        self.labelWidth.grid(row = 3, column = 0)
        self.WidthSbox = Spinbox(self.lframeDes, from_ = 200, to = 2000, command = self.applyDesign)
        self.SetValueToSBox(self.WidthSbox, viewDes[3])
        self.WidthSbox.grid(row = 3, column = 1)

        self.designButtonFrame = Frame(self.tkobj)

        self.applyDesignButton = tk.Button(self.designButtonFrame, text ="Apply", command = self.applyDesign)
        self.applyDesignButton.grid(row = 0, column = 0)
        self.saveDesignButton = tk.Button(self.designButtonFrame, text ="Save Design", command = self.saveDesign)
        self.saveDesignButton.grid(row = 0, column = 1)
        self.loadDesignButton = tk.Button(self.designButtonFrame, text ="Load Design", command = self.loadDesign)
        self.loadDesignButton.grid(row = 0, column = 2)

        self.designButtonFrame.pack()