import Tkinter as tk
from Tkinter import Menu
import Tkinter, Tkconstants, tkFileDialog
from Tkinter import *

import matplotlib
from matplotlib.figure import Figure
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
from matplotlib import pylab
import matplotlib.pyplot as plt

import numpy as np

import ntpath

from datahandler import DataHandler
from weightsdialog import WeightDialog
from aboutdialog import AboutDialog

class MainWindow:

    def UpdateWindowTitle(self):

        titleSting = "Scatter Plot - data: %dataname, log: %logname"

        dataName = ntpath.basename(self.fileName[0])
        logName = ntpath.basename(self.fileName[1])

        self.master.title(titleSting.replace("%dataname", dataName).replace("%logname", logName))


    def ShowAboutDialog(self):
        AboutDialog(self)

    def OpenDataSetFile(self):
        options = {}
        options['defaultextension'] = '.csv'
        options['filetypes'] = [('CSV files', '.csv')]
        options['initialdir'] = './'
        options['parent'] = self.master
        options['title'] = 'Open Csv Files'

        file = tkFileDialog.askopenfile(mode = 'r', **options)

        if file == None:
            return

        self.data_handler.LoadCSVData(file.name)

        self.UpdatePlot(self.currDesign)

        self.fileName[0] = file.name
    
        self.UpdateWindowTitle() 

    def LoadProjectFile(self):

        options = {}
        options['defaultextension'] = '.npz '
        options['filetypes'] = [('npz ', '.npz ')]
        options['initialdir'] = './'
        options['parent'] = self.master
        options['title'] = 'Save project file'

        file = tkFileDialog.askopenfile(mode = 'r', **options)

        if file == None:
            return

        data = np.load(file.name)
        
        weights = data['weights'][0]
        self.currDesign = data['design'][0]
        self.data_handler.dataSet = data['dataset'][0]
        self.data_handler.log = data['log'][0]

        self.weight_handler.SetWeightsInSbox(weights)
        self.weight_handler.SetDesignInSbox(self.currDesign)

        self.UpdatePlot(self.currDesign)

        if 'fnames' in data.keys():
            self.fileName = data['fnames'][0]

        else:
            self.fileName = ["",""]

        self.UpdateWindowTitle() 

    def SaveProjectFile(self):
        options = {}
        options['defaultextension'] = '.npz '
        options['filetypes'] = [('npz ', '.npz ')]
        options['initialdir'] = './'
        options['parent'] = self.master
        options['title'] = 'Save project file'

        file = tkFileDialog.asksaveasfile(mode = 'w', **options)

        if file == None:
            return

        np.savez_compressed(file.name, dataset  = [self.data_handler.dataSet], log = [self.data_handler.log], design = [self.currDesign], weights = [self.weight_handler.GetWeights()], fnames = [self.fileName])



    def OpenLogFile(self):

        options = {}
        options['defaultextension'] = '.csv'
        options['filetypes'] = [('Log files', '.log'),('Log files', '.log.txt')]
        options['initialdir'] = './'
        options['parent'] = self.master
        options['title'] = 'Open Log Files'

        file = tkFileDialog.askopenfile(mode = 'r', **options)

        if file == None:
            return

        self.data_handler.LoadLogData(file.name)

        self.fileName[1] = file.name

        self.UpdateWindowTitle()


    def SaveFigure(self):

        options = {}
        options['defaultextension'] = '.png '
        options['filetypes'] = [('png', '.png'), 
                                ('pdf', '.pdf'), 
                                ('svg', '.svg')]
        options['initialdir'] = './'
        options['parent'] = self.master
        options['title'] = 'Save Image'

        file = tkFileDialog.asksaveasfile(mode = 'w', **options)

        if file == None:
            return

        self.fig.savefig(file.name)


    def EvalWeights(self, weigths):

        if len(self.data_handler.log) == 0:
            print "no log file loaded"
            return self.currDesign

        design = self.data_handler.GetBestDesign(weigths)

        temp = design[2]
        design[2] = design[3]
        design[3] = temp

        self.UpdatePlot(design)

        return design


    #http://matplotlib.org/users/colormaps.html
    def UpdatePlot(self, design):
        

        NUM_COLORS = len(self.data_handler.dataSet)

        colors = []

        if NUM_COLORS == 1:
            colors = [(0,0,0)]

        else:
            cm = pylab.get_cmap('jet')
            for i in range(NUM_COLORS):
                idx = (float(i)/float(NUM_COLORS))
                colors.append(cm((float(i)/float(NUM_COLORS))))

        if design[2] != self.currDesign[2] or design[3] != self.currDesign[3]:

            self.fig.set_size_inches(design[3] / self.dpi, (design[3] * design[2]) / self.dpi, forward=True)
            self.master.geometry(str(int(design[3]))+"x"+str(int(design[3] * design[2])))


        self.fig.clear()
        self.splot = self.fig.add_subplot(111)

        for i,cluster in enumerate(self.data_handler.dataSet):

            
            self.splot.scatter(cluster[:,0], cluster[:,1],
                                 s = design[0] * design[0],
                                 marker = "o",
                                 c = colors[i] , alpha = float(design[1])/255.0, edgecolor='none')
        
        
        self.dataPlot.show()
        
        self.currDesign = design


        
    def __init__(self, master):

        self.master = master

        self.fileName = ["",""]

        self.UpdateWindowTitle()        

        self.defaultDesign = [20.,67.,1.,1000.]
        self.currDesign = self.defaultDesign

        self.weight_handler = WeightDialog(self)
        self.data_handler = DataHandler()

        self.menubar = Menu(master)
        menu = Menu(self.menubar, tearoff=0)
        self.menubar.add_cascade(label="File", menu=menu)
        menu.add_command(label="Open Dataset", command = self.OpenDataSetFile)
        menu.add_command(label="Open Log File", command = self.OpenLogFile)
        menu.add_command(label="Save Project File", command = self.SaveProjectFile)
        menu.add_command(label="Load Project File", command = self.LoadProjectFile)
        menu.add_command(label="Save Figure", command = self.SaveFigure)

        menuAbout = Menu(self.menubar, tearoff=0)
        self.menubar.add_cascade(label="?", menu=menuAbout)
        menuAbout.add_command(label="About", command = self.ShowAboutDialog)

        self.master.config(menu=self.menubar)

        self.dpi = 72
        self.fig = Figure(figsize = (1000/self.dpi, 1000/self.dpi), dpi = self.dpi)
        self.splot = self.fig.add_subplot(111)
        self.dataPlot = FigureCanvasTkAgg(self.fig, master=self.master)
        self.dataPlot.show()
        self.dataPlot.get_tk_widget().pack(expand="yes")

        self.UpdatePlot(self.defaultDesign)

        
