import numpy as np


class DataHandler:

    def __init__(self):

        self.log = np.array([])
        self.dataSet = []

        

    def LoadCSVData(self,filepath):

        self.dataSet = []

        data = np.genfromtxt(filepath, delimiter = ',', dtype = None, names = True)
        header = data.dtype.names
        clusterCol = data[header[2]]
        clusters = np.unique(clusterCol)

        X = data[header[0]]
        Y = data[header[1]]

        for cluster in clusters:
            cluster_rows = np.where(clusterCol == cluster)
            X_cluster = X[cluster_rows]
            Y_cluster = Y[cluster_rows]
            cluster = np.column_stack((X_cluster, Y_cluster))

            self.dataSet.append(cluster)


    def LoadLogData(self,filepath):

        self.log = np.array([])

        data = np.genfromtxt(filepath, delimiter = '|', dtype = None, names = True, skip_footer = 1)

        headersNeeded = ["marker_size","marker_opacity", "image_width", "image_aspect_ratio",
                         "axis_error_foreachcluster", "angle_error_foreachcluster", "overlapFactor", "overplottingFactor", 
                         "lightnessFactor", "meanFactor", "contrastFactor", "ClusterPerceivability","OutliersPerceivability"]

        numClusters = np.unique(data["noOfClusters"])[0]

        columns = []

        for header in headersNeeded:

            logCol = data[header]

            if "foreachcluster" in header and numClusters > 1:
                #logCol = np.core.defchararray.split(logCol[:],sep = ",").astype(np.float)
                logCol = np.array(np.core.defchararray.split(logCol,sep = ","))
                columns.append(np.array([np.sum(np.array(logCol[i]).astype(np.float64)) for i in range(len(logCol))]))
                
            else:
                columns.append(logCol)


        self.log = np.column_stack(columns)


    def GetBestDesign(self, weights):

        norm_weights = np.divide(weights, np.linalg.norm(weights))
        factorLogs = self.log[:, 4:]
        designLogs = self.log[:, :4]

        objScores = [np.dot(logsRow, norm_weights) for logsRow in factorLogs]

        minIdx = np.argmin(objScores)
        return np.array(designLogs[minIdx])


