% Load saved figures
linear=hgload('results/linear-pcenters.fig');
tactile=hgload('results/tactile-pcenters.fig');
touch=hgload('results/touch-pcenters.fig');
midair=hgload('results/midair-pcenters.fig');
% Prepare subplots
figure
h(1)=subplot(1,4,1);
h(2)=subplot(1,4,2);
h(3)=subplot(1,4,3);
h(4)=subplot(1,4,4);
%Paste figures on the subplots
linkaxes(h);
ylim([0 34])
xlim([0.3 2])

copyobj(allchild(get(linear,'CurrentAxes')),h(1));
copyobj(allchild(get(tactile,'CurrentAxes')),h(2));
copyobj(allchild(get(touch,'CurrentAxes')),h(3));
copyobj(allchild(get(midair,'CurrentAxes')),h(4));
%Add legends
%l(1)=legend(h(1),'LegendForFirstFigure')
%l(2)=legend(h(2),'LegendForSecondFigure')
saveas(gcf,'results/pcenters.fig');
saveas(gcf,'results/pcenters.png');