﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TemporalPointingTestDriver
{
    class Condition
    {
        public enum buttonType
        {
            PHYSICAL,
            TOUCH
        };

        public enum actuationType
        {
            TRADITIONAL,
            MAX
        };

        public int distance;
        public int width;
        public buttonType button;
        public actuationType actuation;

        public Condition(int distance, int width, buttonType button, actuationType actuation)
        {
            this.distance = distance;
            this.width = width;
            this.button = button;
            this.actuation = actuation;
        }

        public static List<Condition> generateConditions(bool baseline=false, bool practice=false, int cond=1)
        {
            List<Condition> conditions = new List<Condition>();

            List<buttonType> btns = Enum.GetValues(typeof(buttonType)).Cast<buttonType>().ToList();
            List<actuationType> acts = Enum.GetValues(typeof(actuationType)).Cast<actuationType>().ToList();
            buttonType btn = buttonType.PHYSICAL;
            actuationType act = actuationType.TRADITIONAL;

            switch(cond)
            {
                case 1:
                    btn = buttonType.PHYSICAL; act = actuationType.TRADITIONAL; break;
                case 2:
                    btn = buttonType.TOUCH; act = actuationType.TRADITIONAL; break;
                case 3:
                    btn = buttonType.PHYSICAL; act = actuationType.MAX; break;
                case 4:
                    btn = buttonType.TOUCH; act = actuationType.MAX; break;
            }

            if(baseline)
            {
                conditions.Add(new Condition(400, 20, buttonType.PHYSICAL, actuationType.TRADITIONAL));
                conditions.Add(new Condition(400, 20, buttonType.TOUCH, actuationType.TRADITIONAL));
            }
            else if (practice)
            {
                conditions.Add(new Condition(400, 101, btn, act));
                conditions.Add(new Condition(400, 76, btn, act));
                conditions.Add(new Condition(200, 51, btn, act));
                conditions.Add(new Condition(200, 51, btn, act));
            }
            else
            //foreach(buttonType b in btns)
            {
                //foreach(actuationType a in acts)
                {
                    for (int td = 200; td <= 600; td += 100)
                    {
                        for (int tw = 50; tw <= 100; tw += 50)
                        { 
                            conditions.Add(new Condition(td, tw, btn, act));
                        }
                    }
                }

                conditions = conditions.OrderBy(o => Guid.NewGuid().ToString()).ToList();
            }


            return conditions;
        }


        public override string ToString()
        {
            String str = "d" + distance;
            str += "\tw" + width;

            switch (button)
            {
                case buttonType.PHYSICAL:
                    str += "\tp"; break;
                case buttonType.TOUCH:
                    str += "\tt"; break;
            }

            switch (actuation)
            {
                case actuationType.TRADITIONAL:
                    str += ",a1"; break;
                case actuationType.MAX:
                    str += ",a2"; break;
            }

            return str;
        }

        public void setCondition(SerialPort sp)
        {
            if (sp.IsOpen)
            {
                sp.WriteLine("d" + distance);
                sp.WriteLine("w" + width);
                sp.WriteLine("l0");

                switch (button)
                {
                    case buttonType.PHYSICAL:
                        sp.WriteLine("p"); break;
                    case buttonType.TOUCH:
                        sp.WriteLine("t"); break;
                }

                switch (actuation)
                {
                    case actuationType.TRADITIONAL:
                        sp.WriteLine("a1"); break;
                    case actuationType.MAX:
                        sp.WriteLine("a2"); break;
                }
            }
        }
    }
}
