int rectSize = 100;     // Diameter of rect
int circleSize = 93;   // Diameter of circle
int[] rectXs = new int[10];
int[] rectYs = new int[10];
color rectColor, circleColor, baseColor, yellow, testColor, blackColor, backColor, darkgray, darkdarkgray;
color rectHighlight, circleHighlight;
color currentColor;
boolean rectOver = false;
boolean circleOver = false;
import processing.serial.*;
Serial myPort;       
boolean onTarget = false;
int targetNo = 0;
PImage img1,img2, img3, img4, img5, img6, img7, img8, img9, img10;
boolean ifConnect = true;
int displayTarget = 0;

void setup() {  
  printArray(Serial.list());
  if (ifConnect)
    {myPort = new Serial(this, Serial.list()[4], 115200);}
  size(1600, 1000);
  rectColor = color(0);
  blackColor = color(0,0,0);
  darkgray = color(75);
  darkdarkgray = color(50);
  rectHighlight = color(51);
  circleColor = color(255);
  testColor = color(240);
  yellow = color(255, 204, 0);
  circleHighlight = color(204);
  baseColor = color(102);
  backColor = color (205);
  currentColor = baseColor;
  for (int i = 0; i<5; i++)
  {
      rectXs[i] = width/2 - 50 + (i-2)*300;
      rectYs[i] = height/2-rectSize/2+30;
  }
  for (int i = 5; i<10; i++)
  {
      rectXs[i] = width/2 - 50 + (i-7)*300;
      rectYs[i] = height/2+400;
  }
  ellipseMode(CENTER);
  img1 = loadImage("curve-01.jpg");
  img1.resize(280, 280);
  img2 = loadImage("curve-02.jpg");
  img2.resize(280, 280);
  img3 = loadImage("curve-03.jpg");
  img3.resize(280, 280);
  img4 = loadImage("curve-04.jpg");
  img4.resize(280, 280);
  img5 = loadImage("curve-05.jpg");
  img5.resize(280, 280);
  img6 = loadImage("curve-06.jpg");
  img6.resize(280, 280);
  img7 = loadImage("curve-07.jpg");
  img7.resize(280, 280);
  img8 = loadImage("curve-08.jpg");
  img8.resize(280, 280);
  img9 = loadImage("curve-09.jpg");
  img9.resize(280, 280);
  img10 = loadImage("curve-10.jpg");
  img10.resize(280, 280);
}

void draw() {
  update(mouseX, mouseY);
  background(backColor);
  for (int i=0; i<10;i++)
  {
    if (i==displayTarget)
    {
      fill(testColor);
      //stroke(0);
      noStroke();
      rect(rectXs[i], rectYs[i]-7, rectSize, rectSize/2,200);
    }
    else
    {
      fill(baseColor);
      //stroke(0);
      noStroke();
      rect(rectXs[i], rectYs[i]-7, rectSize, rectSize/2,200);
    }
  }
  
  for (int i=0; i<10;i++)
  {
    if (i==displayTarget)
    {
      fill(darkgray);
      textSize(22);
      text("select", rectXs[i]+19, rectYs[i]+25);
    }
    else
    {
      fill(circleColor);
      textSize(22);
      text("select", rectXs[i]+19, rectYs[i]+25); 
    }
  }
  for (int i=0; i<10;i++)
  {
    if (i==0)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Light", rectXs[i]+20, rectYs[i]-310);
    }
    if (i==1)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Heavy", rectXs[i]+15, rectYs[i]-310);
    }
    if (i==2)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Lock", rectXs[i]+20, rectYs[i]-310);
    }
    if (i==3)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Click", rectXs[i]+15, rectYs[i]-310);
    }
    if (i==4)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Smooth", rectXs[i], rectYs[i]-310);
    }
    if (i==5)
    {
      fill(darkdarkgray);
      textSize(25);
      text("2-Click", rectXs[i]+5, rectYs[i]-310);
    }
    if (i==6)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Slow-release", rectXs[i]-25, rectYs[i]-310);
    }
    if (i==7)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Resisting", rectXs[i], rectYs[i]-310);
    }
    if (i==8)
    {
      fill(darkdarkgray);
      textSize(25);
      text("Asymmetric", rectXs[i]-25, rectYs[i]-310);
    }
    if (i==9)
    {
      fill(darkdarkgray);
      textSize(25);
      text("2-State", rectXs[i], rectYs[i]-310);
    }
  }
  
  fill(circleColor);
  textSize(60);
  text("Button Simulator", width/2 - 240, 70); 
  
  
  image(img1, rectXs[0]-90, rectYs[0]-300);
  image(img2, rectXs[1]-90, rectYs[0]-300);
  image(img3, rectXs[2]-90, rectYs[0]-300);
  image(img4, rectXs[3]-90, rectYs[0]-300);
  image(img5, rectXs[4]-90, rectYs[0]-300);
  
  image(img6, rectXs[5]-90, rectYs[5]-300);
  image(img7, rectXs[6]-90, rectYs[5]-300);
  image(img8, rectXs[7]-90, rectYs[5]-300);
  image(img9, rectXs[8]-90, rectYs[5]-300);
  image(img10, rectXs[9]-90, rectYs[5]-300);
}

void update(int x, int y) {
  boolean onTarget_now = false;
  for (int i=0; i<10;i++)
  {
    if ( overRect(rectXs[i], rectYs[i], rectSize, rectSize/2) ) 
    {
        onTarget = true;
        onTarget_now = true;
        targetNo = i;
    }
  }
  if (onTarget_now== false)
  {onTarget = false;}
}

void mousePressed() 
{
  if (onTarget) 
  {
      if (ifConnect)
      {myPort.write(targetNo);}
      displayTarget = targetNo;
  }
}

boolean overRect(int x, int y, int width, int height)  {
  if (mouseX >= x && mouseX <= x+width && 
      mouseY >= y && mouseY <= y+height) {
    return true;
  } else {
    return false;
  }
}
