function isMobile(){
    var isMobile = false; //initiate as false
    // device detection
    if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4))) { 
        isMobile = true;
    }
    return isMobile;
}

$(document).ready(function () {

    if (isMobile()){
        $('button#results-btn').attr("disabled", "disabled");
    }

    var ageValid = false;
    var genderValid = false;
    var langValid = false;

    var typeCourseValid = false;
    var typeTimeValid = false;
    var typeHowValid = false;
    var kbValid = false;
    var layoutValid = false;

    var kbAppValid = false;
    var kbAdvanced = false;

    var swiper = new Swiper('.swiper-container', {
        noSwiping: true,
        noSwipingClass: 'swiper-no-swiping',
        pagination: {
            el: '.swiper-pagination',
            type: 'progressbar',
        },
        navigation: {
            nextEl: '.slide-next',//'.swiper-button-next',
            prevEl: '.slide-prev'
        },
    });

    $('.slide-next').on('click', function(){
        window.scrollTo(0,0);
    });

    var device = isMobile() ? 'mobile' : 'desktop';
    $('#device-disclaimer').text(device);
    if (device == 'mobile'){
        $('#keyboard-app-row').show();
        $('#keyboard-feat-row').show();
    } else {
        $('#keyboard-app-row').hide();
        $('#keyboard-feat-row').hide();
    }

    /* Creating language selector */
    var languages = navigator.languages || [navigator.language];
    let uniqueLang = [...new Set(languages.map(function(e) {return e.split('-')[0]}))]
    for (var i = 0; i<uniqueLang.length; i++){
        var key = uniqueLang[i].split('-')[0];
        var value = isoLangs[key];
        $('#native-language').append($('<option>', {value: key, text: value.name}));
    }
    $.each(isoLangs, function (key, value) {
        $('#native-language').append($('<option>', {value: key,text: value.name}));
    });

    /* Creating keyboard apps selector */
    $.each(keyboardApps, function (key, value) {
        $('#keyboard-app').append('<option value="' + key + '">' + value+ '</option>');
    });


    function slideValidation(target, number_valid=1){
        var currentSlide = target.closest('.slide-container:has(button)');

        // SELECTORS
        var selector_not_exists = currentSlide.find("select").length == 0;
        var selector_selected = currentSlide.find("select option:selected");
        var selector_initial_val = currentSlide.find("select option:nth(0)").val();
        var selector_valid = (selector_selected.val() != selector_initial_val);


        // RADIO BUTTONS
        var radios = currentSlide.find("input:radio");
        var radio_groups = [];
        for (var i=0; i<radios.length; i++){
            radio_groups.push(currentSlide.find("input:radio")[i].name);
        }
        var u_groups = $.unique(radio_groups);
        var radio_groups_valid = true;
        for (var i=0; i<u_groups.length; i++){
            var group = u_groups[i];
            if ((group != "type-English") || (selector_selected.val() != 'en') ){
                radio_groups_valid *= currentSlide.find("input:radio[name="+group+"]:checked").length > 0;
            }
        }

        // CHECKBOXES 
        var cb_not_exists = currentSlide.find("input:checkbox").length == 0;
        var cb_shecked = currentSlide.find("input:checkbox:checked").length > 0; // required?
        
        // TEXT INPUTS 
        var text_valid = true;
        var text_inputs = currentSlide.find("input:text").not('[name*="other"],[id*="other"]');
        for (var i = 0; i< text_inputs.length; i++){
            text_valid *= numberValidation($(text_inputs[i]));
        }
        // TEXT INPUTS "OTHER" are only visible when "Other" checkbox/radio selected.
        // if they ARE visible, they should not be empty
        var other_text_valid = true;
        var other_text_inputs = currentSlide.find("input:text[name*='other'],input:text[id*='other']");
        for (var i = 0; i< other_text_inputs.length; i++){
            if ($(other_text_inputs[i]).is(':visible')) 
                text_valid *= $(other_text_inputs[i]).val() != "";
        }

        // THE WHOLE SLIDER
        var slideValid = radio_groups_valid * (cb_not_exists + cb_shecked) * text_valid * (selector_not_exists + selector_valid) * number_valid;
        
        if (slideValid){// TODO this should be done for the WHOLE slide
            currentSlide.find('button.slide-next').removeAttr("disabled");
            currentSlide.find('button#results-btn').removeAttr("disabled");
        } else{
            currentSlide.find('button.slide-next').attr("disabled", "disabled");
            currentSlide.find('button#results-btn').attr("disabled", "disabled");
        }
    }


    var $age = $('#age');
    $age.keyup(function(event) {
      var number_valid = numberValidation($age);
      slideValidation($(this), number_valid);
    });

    $age.touchend(function(event) {
      var number_valid = numberValidation($age);
      slideValidation($(this), number_valid);
    });

    var $tst = $('#time-spent-typing');
    $tst.keyup(function(event) {
      var number_valid = numberValidation($tst);
      slideValidation($(this), number_valid);
    });

    $tst.touchend(function(event) {
      var number_valid = numberValidation($tst);
      slideValidation($(this), number_valid);
    });


    var $nh = $('#nfingers-habit');
    $nh.keyup(function(event) { slideValidation($(this)); });
    $nh.touchend(function(event) { slideValidation($(this)); });

    var $oh = $('#other-habit');
    $oh.keyup(function(event) { slideValidation($(this)); });
    $oh.touchend(function(event) { slideValidation($(this)); });

    var $ok = $('#other-keyboard');
    $ok.keyup(function(event) { slideValidation($(this)); });
    $ok.touchend(function(event) { slideValidation($(this)); });
    
    var $ol = $('#other-layout');
    $ol.keyup(function(event) { slideValidation($(this)); });
    $ol.touchend(function(event) { slideValidation($(this)); });

    var $oka = $('#other-keyboard-app');
    $oka.keyup(function(event) { slideValidation($(this)); });
    $oka.touchend(function(event) { slideValidation($(this)); });

    var $oc = $('#other-cb');
    $oc.keyup(function(event) { slideValidation($(this)); });
    $oc.touchend(function(event) { slideValidation($(this)); });


    function numberValidation(el){
        if (el[0]==$tst[0]){
            if ($tst.val() == "") {
                $tst.addClass('invalid');
                return 0;
            }
            var value = Number($tst.val());
            if (value >= 0 && value <= 24) {
                $tst.removeClass('invalid');
                return 1;
            } else {
                $tst.addClass('invalid');
                return 0;
            }
        }
        if (el[0]==$age[0]){
            var value = Number($age.val());
            if (value >= 1 && value <= 120) {
                $age.removeClass('invalid');
                return 1;
            } else {
                $age.addClass('invalid');
                return 0;
            }
        }
        return 1;
    }


    $('input:radio[name="gender"]').change(function(event) {
        slideValidation($(this));
    });

    $('input:radio[name="typing-course"]').change(function(event) {
        slideValidation($(this));
    });

    $('#native-language').change(function(event) {
        if ($('#native-language').val() != 'en'){
            $('#how-often-eng-row').show();
        } else {
            $('#how-often-eng-row').hide();
        }
        slideValidation($(this));
    });

    $('input:radio[name="type-English"]').change(function(event) {
        slideValidation($(this));
    });

    $('input:radio[name="typing-habit-hand"]').change(function(event) {
        slideValidation($(this));
    });

    $('#nfingers-habit').hide();
    $('input:radio[name="typing-habit-finger"]').change(function(event) {
        if ($('input:radio[name="typing-habit-finger"]:checked').val() == "other-nfingers"){
            $('#nfingers-habit').show();
        } else {
            $('#nfingers-habit').hide();
        }
        slideValidation($(this));
    });

    $('#other-habit').hide();
    $('input:radio[name="typing-habit-finger"]').change(function(event) {
        if ($('input:radio[name="typing-habit-finger"]:checked').val() == "other"){
            $('#other-habit').show();
        } else {
            $('#other-habit').hide();
        }
        slideValidation($(this));
    });

    $('#other-keyboard').hide();
    $('input:radio[name="keyboard-type"]').change(function(event) {
        if ($('input:radio[name="keyboard-type"]:checked').val() == "other"){
            $('#other-keyboard').show();
        } else {
            $('#other-keyboard').hide();
        }
        slideValidation($(this));
    });

    $('#other-layout').show();
    $('input:radio[name="keyboard-layout"]').change(function(event) {
        if ($('input:radio[name="keyboard-layout"]:checked').val() == "other"){
            $('#other-layout').show();
        } else {
            $('#other-layout').hide();
        }
        slideValidation($(this));
    });

    // Slide for mobile users only
    if (device == 'mobile'){
        $('#other-cb').hide();
        $('input:checkbox[name="using-features"]').change(function(event) {
            var checked = false;
            $("input:checkbox[name=using-features]:checked").each(function(){
                if ($(this).val() == "other"){
                    $('#other-cb').show();
                    checked = true;
                }
                if (!checked)
                    $('#other-cb').hide();
            });
            slideValidation($(this));
        });

        $('#using-keyboard-app').hide();
        $('input:radio[name="using-app"]').change(function(event) {
            if ($('input:radio[name="using-app"]:checked').val() == "true"){
                $('#using-keyboard-app').show();
                $('#keyboard-app').val( $("#keyboard-app option:nth(0)").val());
            } else {
                $('#using-keyboard-app').hide();
                $('#keyboard-app').val( $("#keyboard-app option:nth(1)").val());
            }
            slideValidation($(this));
        });

        $("#other-keyboard-app").hide();
        $('#keyboard-app').change(function(event) {
            if ($('#keyboard-app').val() == "other"){
                $("#other-keyboard-app").show();
            }
            else {
                $("#other-keyboard-app").hide();
            }
            slideValidation($(this));
        });
    }

    $("#questionnaire-form").submit(function (event) {
        
        event.preventDefault();

        var features = [];

        if (isMobile()){

            $("input:checkbox[name=using-features]:checked").each(function(){
                features.push($(this).val());
            });

            var whichApp = $('#keyboard-app').val()=='other'? $('#other-keyboard-app').val() : $('#keyboard-app').val();
            var usingApp = '';
            if ($('input:radio[name="using-app"]:checked').val()=='true'){
                usingApp = whichApp;
            } else {
                usingApp = $('input:radio[name="using-app"]:checked').val();
            }
        }

        var fingers_val = $('input:radio[name="typing-habit-finger"]:checked').val(); 

        if (fingers_val == $('input:radio[id="fingers-2-rdio"]').val()){
            // if "more than two fingers" selected 
            fingers_val = fingers_val + ';' + $('#nfingers-habit').val();
        } 

        var hand_val = $('input:radio[name="typing-habit-hand"]:checked').val();
        var fingers = hand_val + ';' + fingers_val;

        var typeEnglish = $('input:radio[name="type-English"]:checked').val();

        $.ajax('questionnaire', {
            url: 'questionnaire',
            type: 'POST',
            contentType: 'application/json; charset=UTF-8',
            dataType: 'json',
            data:
                JSON.stringify(
                    {
                        age: parseInt($('#age').val()) || 0,
                        gender: $('input:radio[name="gender"]:checked').val(),
                        nativeLanguage: $('#native-language').val(),
                        hasTakenTypingCourse: $('input:radio[name="typing-course"]:checked').val(),
                        timeSpentTyping: $('#time-spent-typing').val(),
                       // timeSpentTypingMob: $('#time-spent-typing-mob').val(),
                        typeEnglish: typeEnglish || '',
                        fingers: fingers || '',
                        keyboardType: $('input:radio[name="keyboard-type"]:checked').val(),
                        layout: $('input:radio[name="keyboard-layout"]:checked').val(),
                        usingApp : usingApp || '',
                        //whichApp : whichApp,
                        usingFeatures : JSON.stringify(features) || ''
                    }),
            success: function(msg) {
                document.location.href = "results";
                return;
            },
            error: function(msg) {
                var error = JSON.parse(msg.responseText).error;
                if (error === "validation_err") {
                    $('html,body').scrollTop(0);
                    $("#alert-row").html('<div class="alert alert-danger">' +
                                            'Please verify that you answered all the questions correctly.' +
                                        '</div>');
                } else if (error === "uid_missing_err" || error === "tsid_missing_err") {
                    document.location.href = "assets/session_err.html";
                    return;
                } else {
                    console.log("Unknown error");
                }
            }
        });
    });
});
