# 136 Million Keystrokes

This repository contains the source code for the UPDATED typing speed test application. 

The previous version of the applicatuon was used to collect the 136 million keystrokes that were analyzed for the
Observations on Typing from 136 Million Keystrokes paper published in CHI' 18.
More information on the project and exact references to the paper can be found
[Here](http://userinterfaces.aalto.fi/136Mkeystrokes/).

The updated (**this**) version is extended to be used on mobile devices. 
The final questionnaire is modified accordingly to capture device data and typing style more carefully. 

## Contents of the repository

The repository contains the code for running the entire typing speed test
application. The code for capturing keystrokes can be found under
`public/javascripts/typingtest.js`.

## Installation

The application is written in Scala with the Play!-framework. To install all
dependencies, run `sbt` in the root directory. You can run the application
with the `sbt run`-command. You can build the binary distribution with `sbt dist`. 
To be able to run the application, you will need a MySQL-database. You can configure the database in `conf/application.conf` (**do not share database passwords in your own further deployment**). To restore the database structure and example sentences on your machine, use provided `DB_structure.sql` and `sentences_content.sql`, respectively. To the description of tracked data, please refer to `tracked_data.json`. 

## Server deployment QuickStart

To deploy a new version on the production server:
1. Go to your home directory: `cd /home/YOUR_USERNAME/`
2. Clone the project from its git repository (done only on the first time): `git clone https://version.aalto.fi/gitlab/beloruk1/typingtest.git`
3. Go to the project directory: `cd typingtest`
4. Update the project: `git pull`
5. Install all dependencies: `sbt`
6. Exit the sbt shell: `exit`
7. Build the binary distribution: `sbt dist`
8. Switch to the root user: `sudo su`
9. Copy the distribution package to the www directory: `cp target/universal/typingmaster-1.2.0.zip /var/www/typingmaster/`
10. Go to the typingmaster directory: `cd /var/www/typingmaster/`
11. Unzip the distribution package: `unzip typingmaster-1.2.0.zip`
12. Stop the application server: `./stop`
13. Start the application server: `./start`

## License

The software is licensed under the MIT license. The license file can be found in
the root of this repository.

## TODO

- Track returning devices (via leaving a device identification cookie)<br>
- Adapt to a weak mobile connection <dr>
- Detect event of browser shifted to a background and log it <br>
