# ************************************************************
# Sequel Pro SQL dump
# Version 4541
#
# http://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: 127.0.0.1 (MySQL 5.7.23-0ubuntu0.16.04.1)
# Database: typingmasterdb
# Generation Time: 2018-09-18 17:00:19 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table KEYSTROKES
# ------------------------------------------------------------

DROP TABLE IF EXISTS `KEYSTROKES`;

CREATE TABLE `KEYSTROKES` (
  `KEYSTROKE_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `PRESS_TIME` bigint(20) NOT NULL,
  `RELEASE_TIME` bigint(20) NOT NULL,
  `LETTER` varchar(10) NOT NULL,
  `TEST_SECTION_ID` int(11) NOT NULL,
  `KEYCODE` int(11) DEFAULT NULL,
  PRIMARY KEY (`KEYSTROKE_ID`),
  KEY `TEST_SECTION_FK` (`TEST_SECTION_ID`),
  CONSTRAINT `TEST_SECTION_FK` FOREIGN KEY (`TEST_SECTION_ID`) REFERENCES `TEST_SECTIONS` (`TEST_SECTION_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table LOG_DATA
# ------------------------------------------------------------

DROP TABLE IF EXISTS `LOG_DATA`;

CREATE TABLE `LOG_DATA` (
  `LOG_DATA_ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `TEST_SECTION_ID` int(11) DEFAULT NULL,
  `TYPE` text,
  `KEY` text,
  `CODE` text,
  `DATA` text,
  `INPUT` text,
  `PRESSED` text,
  `TIMESTAMP` bigint(20) DEFAULT NULL,
  `DEVICE_ORIENTATION` text,
  `SCREEN_ORIENTATION` text,
  PRIMARY KEY (`LOG_DATA_ID`),
  KEY `TEST_SECTION_FFK` (`TEST_SECTION_ID`),
  CONSTRAINT `TEST_SECTION_FFK` FOREIGN KEY (`TEST_SECTION_ID`) REFERENCES `TEST_SECTIONS` (`TEST_SECTION_ID`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table PARTICIPANTS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `PARTICIPANTS`;

CREATE TABLE `PARTICIPANTS` (
  `PARTICIPANT_ID` int(11) NOT NULL AUTO_INCREMENT,
  `IP_ADDRESS` varchar(32) DEFAULT NULL,
  `BROWSER` text,
  `BROWSER_LANGUAGE` varchar(255) DEFAULT NULL,
  `DEVICE` varchar(16) DEFAULT NULL,
  `SCREEN_W` int(11) DEFAULT NULL,
  `SCREEN_H` int(11) DEFAULT NULL,
  `AGE` int(11) DEFAULT NULL,
  `GENDER` varchar(16) DEFAULT NULL,
  `HAS_TAKEN_TYPING_COURSE` tinyint(1) DEFAULT NULL,
  `LAYOUT` varchar(16) DEFAULT NULL,
  `WPM` double DEFAULT NULL,
  `ERROR_RATE` double DEFAULT NULL,
  `NATIVE_LANGUAGE` varchar(32) DEFAULT NULL,
  `KEYBOARD_TYPE` varchar(16) DEFAULT NULL,
  `USING_APP` text,
  `USING_FEATURES` text,
  `FINGERS` text,
  `TIME_SPENT_TYPING` varchar(16) DEFAULT NULL,
  `TYPE_ENGLISH` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`PARTICIPANT_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table SENTENCES
# ------------------------------------------------------------

DROP TABLE IF EXISTS `SENTENCES`;

CREATE TABLE `SENTENCES` (
  `SENTENCE_ID` int(11) NOT NULL AUTO_INCREMENT,
  `SENTENCE` varchar(255) NOT NULL,
  `SOURCE` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`SENTENCE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table TEST_SECTIONS
# ------------------------------------------------------------

DROP TABLE IF EXISTS `TEST_SECTIONS`;

CREATE TABLE `TEST_SECTIONS` (
  `TEST_SECTION_ID` int(11) NOT NULL AUTO_INCREMENT,
  `SENTENCE_ID` int(11) NOT NULL,
  `PARTICIPANT_ID` int(11) NOT NULL,
  `USER_INPUT` varchar(255) DEFAULT NULL,
  `INPUT_TIME` bigint(20) DEFAULT NULL,
  `EDIT_DISTANCE` int(11) DEFAULT NULL,
  `ERROR_RATE` double DEFAULT NULL,
  `WPM` double DEFAULT NULL,
  `INPUT_LENGTH` int(11) DEFAULT NULL,
  `ERROR_LEN` int(11) DEFAULT NULL,
  `POTENTIAL_WPM` double DEFAULT NULL,
  `POTENTIAL_LENGTH` int(11) DEFAULT NULL,
  `DEVICE` text,
  PRIMARY KEY (`TEST_SECTION_ID`),
  KEY `PARTICIPANT_FK` (`PARTICIPANT_ID`),
  KEY `SENTENCE_FK` (`SENTENCE_ID`),
  CONSTRAINT `PARTICIPANT_FK` FOREIGN KEY (`PARTICIPANT_ID`) REFERENCES `PARTICIPANTS` (`PARTICIPANT_ID`),
  CONSTRAINT `SENTENCE_FK` FOREIGN KEY (`SENTENCE_ID`) REFERENCES `SENTENCES` (`SENTENCE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
