
var unresolvedKeypresses = []; // Array for associating keydown-, keypress- and keyup-events
var sentenceCount = 0; // Current sentence
var totalSentences = 15; // Number of sentences per participant
var toSubmit = [];  // Keystrokes to submit
var logdata_toSubmit = []; // Logdata to submit
var keypressCount = 0; // Counter of keypresses since last push to the server
var keyFlags = [145]; // Flag of the key state. False if key is up, true if down
var keys = {};

var dev_orientation = {alpha:"", beta:"", gamma:""};
var device;

function isMobile(){
    var isMobile = false; //initiate as false
    // device detection
    if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4))) { 
        isMobile = true;
    }
    return isMobile;
}

$(document).ready(function() {
    device = isMobile() ? 'mobile' : 'desktop';

    for (var i = 0; i < keyFlags.length; i++) {
        keyFlags[i] = false;
    }

    var $testInput = $('#test-input');
    var $errorRate = $('#error-rate');
    var $nextBtn = $('#next-btn');

    var processing = false;

    function parseError(msg) {
        var error = JSON.parse(msg.responseText).error;
        if (error === "uid_missing_err" || error === "tsid_missing_err") {
            document.location.href = "assets/session_err.html";
            return;
        } else {
            console.log("Unknown error");
        }
    }

    getNewSentence(true);

    matchBoxes();

    $testInput.focus();

    function getNewSentence(first) {

        if (first) {
            typingtestRoutes.controllers.TypingTest.getWPM().ajax({
                success: function (result) {
                    $('#wpm').html(result.wpm);
                }
            });
            typingtestRoutes.controllers.TypingTest.getErrorRate().ajax({
                success: function (result) {
                    $errorRate.html(result.errorRate.toFixed(2) + "%");
                    if (result.errorRate > 5) {
                        $errorRate.css('color', 'red');
                    } else if (result.errorRate <= 5) {
                        $errorRate.css('color', '#4747a3');
                    }
                },
                error: function(error) {
                    parseError(error);
                }
            });

        }

        typingtestRoutes.controllers.TypingTest.sentence(first).ajax({
            success: function (result) {
                $('#test-sentence').text(result.sentence);
                $('#test-input').height( $('#test-sentence').height() );
                sentenceCount = parseInt(result.count);
                $('#sentence-count').html(sentenceCount.toString() + "/" + totalSentences.toString());
            },
            error: function(error) {
                parseError(error);
            }
        });
    }

    $nextBtn.click(function () {
        setTimeout(testSectionEnd, 100);
        $testInput.focus();
    });

    $testInput.bind('paste', function (e) {
        e.preventDefault();
    });

    function testSectionEnd() {
        $.mobile.loading("show");
        if ($testInput.val() == "") {
            return;
        }
        $nextBtn.attr('disabled', true);
        $nextBtn.addClass('disabled');
        $testInput.attr('disabled', true);
        processing = true;
        $('#test-sentence').val('');
        var input = $testInput.val().trim();
        $testInput.val("");
        keypressCount = 0;
        setTimeout(function() {
            saveKeystrokes(function(msg) {
                $.ajax('userInput', {
                    url: 'userInput',
                    type: 'POST',
                    contentType: 'application/json; charset=UTF-8',
                    dataType: 'json',
                    data:
                        JSON.stringify(
                            {
                                userInput: input,
                                device : device
                            }),
                    success: function(msg) {
                        if(sentenceCount >= totalSentences) {
                            typingtestRoutes.controllers.TypingTest.updateStats().ajax({
                                success: function (result) {
                                    if (result.questionnaire === "true") {
                                        document.location.href = "results";
                                    } else {
                                        document.location.href = "questionnaire";
                                    }
                                },
                                error: function(error) {
                                    parseError(error);
                                }
                            });
                            return;
                        }
                        typingtestRoutes.controllers.TypingTest.getWPM().ajax({
                            success: function (result) {
                                $('#wpm').html(result.wpm);
                            },
                            error: function(error) {
                                parseError(error);
                            }
                        });
                        typingtestRoutes.controllers.TypingTest.getErrorRate().ajax({
                            success: function (result) {
                                $errorRate.html(result.errorRate.toFixed(2) + "%");
                                if (result.errorRate > 5) {
                                    $errorRate.css('color', 'red');
                                } else if (result.errorRate <= 5) {
                                    $errorRate.css('color', '#4747a3');
                                }
                                getNewSentence(false);
                            },
                            error: function(error) {
                                parseError(error);
                            }
                        });

                    },
                    error: function(error) {
                        parseError(error);
                    },
                    complete: function() {
                        $testInput.attr('disabled', false);
                        $nextBtn.attr('disabled', false);
                        $nextBtn.removeClass('disabled');
                        $testInput.focus();
                        processing = false;
                        $.mobile.loading("hide");
                    }
                });
            });
            saveLogData();
        }, 50);
    }

    function saveKeystrokes(callback) {
        var ks = toSubmit.slice(0);
        toSubmit = [];
        $.ajax('keystrokes', {
            url: 'keystrokes',
            type: 'POST',
            contentType: 'application/json; charset=UTF-8',
            dataType: 'json',
            data:
                JSON.stringify(
                    {
                        keystrokes: ks
                    }),
            success: callback,
            error: function(error) {
                parseError(error);
            }
        });
    }

    $testInput.keydown(function(event) {
        var time = $.now();
        if (keyFlags[event.keyCode]) {
            if (event.keyCode >= 65 && event.keyCode <= 90) {
                var inputValue = $testInput.val();
                $testInput.val(inputValue.slice(0, inputValue.length - 1));
            }
            return;
        }
        var letter;
        keyFlags[event.keyCode] = true;
        $.each(keycodes, function (key, value) {
            if (event.keyCode == key) {
                letter = value;
            }
        });

        unresolvedKeypresses.push(new UnresolvedKeypress(event, letter, event.keyCode, time));

        // Additional data, including data for mobile version 
        keys[event.which] = true;
        var orient = getScreenOrientation();
        data = {
            etype: String(event.type), 
            key: String(event.originalEvent.key),
            code: String(event.originalEvent.code),
            data: String(event.originalEvent.data) || '',
            input: String($testInput.val()),
            pressed: String(whichPressed(keys)),
            timestamp: time,
            screen_orientation: JSON.stringify(orient),
            device_orientation: JSON.stringify(dev_orientation)
        };

        logdata_toSubmit.push(data);
        //saveLog(data);
    
    });

    $testInput.on('keypress', function(event) {
        var time = $.now();
        if (event.which === 13 && !processing) {
            testSectionEnd();
        } else {
            for (var i = 0; i < unresolvedKeypresses.length; i++) {
                if (unresolvedKeypresses[i] == undefined) {
                    continue;
                } else if (unresolvedKeypresses[i].downTime >= (time - 20) && unresolvedKeypresses[i].downTime <= time) {
                    unresolvedKeypresses[i].letter = String.fromCharCode(event.keyCode);
                    keypressCount++;
                    break;
                }
            }
        }
    });

    $testInput.keyup(function(event) {
        var time = $.now();
        for (var i = 0; i < unresolvedKeypresses.length; i++) {
            var unresolved = unresolvedKeypresses[i];
            // On mobile devices keycode is always undefined => add workaround (to get wpm)
            if (unresolved == undefined || (!isMobile() && unresolved.letter == undefined)) {
                continue;
            } else if (unresolved.keydown.keyCode === event.keyCode) {
                toSubmit.push(
                    {
                        pressTime: unresolved.downTime,
                        releaseTime: time,
                        keycode: unresolved.keycode,
                        letter: unresolved.letter || ''
                    });
                delete unresolvedKeypresses[i];
                break;
            }
        }

        keyFlags[event.keyCode] = false;

        if (keypressCount >= 10) {
            keypressCount = 0;
            saveKeystrokes(function () {

            });

            saveLogData();
        }

        // Additional data for mobile devices 
        keys[event.which] = false;
        var orient = getScreenOrientation();
        data = {
            etype: String(event.type), 
            key: String(event.originalEvent.key),
            code: String(event.originalEvent.code),
            data: String(event.originalEvent.data) || '',
            input: String($testInput.val()),
            pressed: String(whichPressed(keys)),
            timestamp: time, 
            screen_orientation: JSON.stringify(orient),
            device_orientation: JSON.stringify(dev_orientation)
        };

        logdata_toSubmit.push(data);
        //saveLog(data);
    
    });

    $testInput.on('input', function(event){
        var time = $.now();
        $("#multiple").innerHTML = isMultiple(keys) ? "+" : "-";
        $("#pressed").innerHTML = whichPressed(keys);
        var orient = getScreenOrientation();
        data = {
            etype: String(event.type), 
            key: String(event.originalEvent.key),
            code: String(event.originalEvent.code),
            data: String(event.originalEvent.data) || '',
            input: String($testInput.val()),
            pressed: String(whichPressed(keys)),
            timestamp: time,
            screen_orientation: JSON.stringify(orient),
            device_orientation: JSON.stringify(dev_orientation)
        };

        logdata_toSubmit.push(data);
        //saveLog(data);

    });    
});

function isMultiple(keys){
  var counter = 0;
  for (var k in keys){
    if (keys[k]==true)
      counter +=1;
  }
  if (counter > 1) return true;
  else return false;
}

function whichPressed(keys){
    var pressed = [];
    if (isMultiple(keys)){
        for (var k in keys){
            if (keys[k]==true)
              pressed.push(k);
          }
    }
    return pressed;
}

function UnresolvedKeypress(keydown, letter, keycode, downTime) {
    this.keydown = keydown;
    this.letter = letter;
    this.keycode = keycode;
    this.downTime = downTime;
}

function saveLogData(){
    var ld = logdata_toSubmit.slice(0);
    logdata_toSubmit = [];
    $.ajax('logdata', {
        url: 'logdata',
        type: 'POST',
        contentType: 'application/json; charset=UTF-8',
        dataType: 'json',
        data: JSON.stringify({logdata: ld }),
        success: function(success){},
        error: function(error) {
            console.log(error);
        }
    });
}

function matchBoxes(){
    if (isMobile()){
        //var orient = getScreenOrientation();
        if (window.orientation == 90){
            //$('#test-input').offset({top : offset_top})
            $('#input-row .test-field').offset(
                { 
                    top: $('#sentence-row .test-field').offset().top 
                });
            $('#input-row .test-field').height($('#sentence-row .test-field').height());

        } else {
            $('#input-row .test-field').offset(
                { 
                    top : ($('#sentence-row .test-field').offset().top + $('#sentence-row .test-field').height() + 25)
                });
        }
    }
}

/**
 * Returns 0 for portrait, 90 for landscape
 */
function getScreenOrientation(){
    if (typeof(screen.orientation) != "undefined") return screen.orientation.angle;
    if (typeof(window.orientation) != "undefined") return window.orientation;
    else return -1;
}

if (isMobile()){

    window.addEventListener('deviceorientation', function(event) {
        dev_orientation.alpha = parseFloat(event.alpha).toFixed(2);
        dev_orientation.beta = parseFloat(event.beta).toFixed(2);
        dev_orientation.gamma = parseFloat(event.gamma).toFixed(2);
    });

    window.addEventListener("orientationchange", function() {
        setTimeout(function(){ 
            matchBoxes();
        }, 400);
    });
}
