var wpmUser;
var wpmChart;
var wpmChartMaxX; // will be set dynamically based on response data
var wpmChartMaxY; // will be set dynamically based on response data
var wpmChartStepSizeX; // will be set dynamically based on response data
var WPM_CHART_STEP_SIZE_Y = 5;
var errorRateUser;
var errorRateChart;
var errorRateChartMaxX; // will be set dynamically based on response data
var errorRateChartMaxY; // will be set dynamically based on response data
var errorRateChartStepSizeX = 0; // will be set dynamically based on response data
var ERROR_RATE_CHART_STEP_SIZE_Y = 5;


function isMobile(){
    var isMobile = false; //initiate as false
    // device detection
    if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4))) { 
        isMobile = true;
    }
    return isMobile;
}

function histogramDataFiller(chart, buckets, counts) {
    var device = isMobile() ? "mobile" : "desktop";

    var WPM_MAX_MOBILE = 100;
    var WPM_MAX_DESKTOP = 150;
    var WPM_MIN = 0; // included
    var WPM_MAX = (device === "mobile") ? WPM_MAX_MOBILE : WPM_MAX_DESKTOP; // excluded
    var WPM_STEP_SIZE = 5;

    var ERROR_RATE_MAX_MOBILE = 20;
    var ERROR_RATE_MAX_DESKTOP = 20;
    var ERROR_RATE_MIN = 0; // included
    var ERROR_RATE_MAX = (device === "mobile") ? ERROR_RATE_MAX_MOBILE : ERROR_RATE_MAX_DESKTOP; // excluded
    var ERROR_RATE_STEP_SIZE = 1;

    var MIN = (chart === "wpm") ? WPM_MIN : ERROR_RATE_MIN;
    var MAX = (chart === "wpm") ? WPM_MAX : ERROR_RATE_MAX;
    var STEP = (chart === "wpm") ? WPM_STEP_SIZE : ERROR_RATE_STEP_SIZE;

    for (var i = MIN; i <= (MAX/STEP); i++) {
        var bucket = i * STEP;
        var count = counts[i];
        // Insert the bucket and count to the correct index position
        if (buckets[i] !== bucket) {
            buckets.splice(i, 0, bucket);
            counts.splice(i, 0, 0);
        }
    }
}

$(document).ready(function () {
    var device = isMobile() ? 'mobile' : 'desktop';
    $('#device-disclaimer').text(device);

    var wpm = $('#wpm').text().trim();
    if (wpm > 500){
         $('#cheat-disclaimer').text('We think you have cheated, but here are your results anyway.');
         $('#cheat-disclaimer').parent().show();
    }

    loadHistogramsData();

    window.fbAsyncInit = function() {
        FB.init({
            appId      : '598038023696960',
            xfbml      : true,
            version    : 'v2.7'
        });
    };

    $('.continue-btn').click(function () {
        document.location.href = "typingtest";
    });

    $('.twitter-btn').click(function() {
        var wpm = $('#wpm').text().trim();
        var msg = "My%20typing%20speed%20is%20" + wpm + "%20words%20per%20minute%21%20What%27s%20yours%3F";
        var url = "http://typingtest.aalto.fi/";
        var hashtags = "typingtest";
        window.open("https://twitter.com/intent/tweet?text=" + msg + "&url=" + url + "&hashtags=" + hashtags);
    });

    $('.fb-btn').click(function () {
        var app_id = 1625191694476822;
        var href = "http://typingtest.aalto.fi/";
        // var redirect_uri = 'http%3A%2F%2Flocal.host%3A9000%2Fassets%2Fclose_fb_dialog.html';
        var wpm = $('#wpm').text().trim();
        var msg = "My%20typing%20speed%20is%20" + wpm + "%20words%20per%20minute%21%20What%27s%20yours%3F";
        // window.open("https://www.facebook.com/dialog/share?app_id=" + app_id + "&display=page&href=" + href + "&redirect_uri=" + redirect_uri + "&quote=" + msg);
        window.open("https://www.facebook.com/dialog/share?app_id=" + app_id + "&display=page&href=" + href + "&quote=" + msg);
    });


    /**
     * GET promise
     * @param {String} url
     */
    function get(url) {
        // Return a new promise.
        return new Promise(function(resolve, reject) {
            // Do the usual XHR stuff
            var req = new XMLHttpRequest();
            req.open('GET', url);
            req.onload = function() {
                // This is called even on 404 etc, so check the status
                if (req.status == 200) {
                    // Resolve the promise with the response text
                    resolve(req.response);
                } else {
                    // Otherwise reject with the status text, which will hopefully be a meaningful error
                    reject(Error(req.statusText));
                }
            };
            // Handle network errors
            req.onerror = function(e) {
                console.log('Error:', e);
                console.log(req.responseText);
                reject(Error("Network Error"));
            };
            // Make the request
            req.send();
        });
    }

    /**
     * Load histograms of Error and WPM and put them on the result page.
     */
    function loadHistogramsData() {
        var device = isMobile() ? 'mobile' : 'desktop';

        get('/getWpmHistogramData?device='+device).then(function(response) {
            wpmUser = Number($('#wpm').text().trim());
            var data = JSON.parse(response);
                    
            if (data.length > 0) {
                createWpmHistogram(data);
                $('#wpmChart').show();
            }
            else {
                // Clear canvas
                $('#wpmChart').hide();
            }
        }, function(error) {
            console.error("GET failed in loading WPM histogram data", error);
        });

        get('/getErrorRateHistogramData?device='+device).then(function(response) {
            errorRateUser = Number($('#error-rate').text().replace('%','').trim());
            var data = JSON.parse(response);

            if (data.length > 0) {
                createErrorRateHistogram(data);
                $('#errorChart').show();
            }
            else {
                // Clear canvas
                $('#errorChart').hide();
            }
        }, function(error) {
            console.error("GET failed in loading error rate histogram data", error);
        });
    }


    /**
     * Create WPM histogram
     */
    function createWpmHistogram(histogramData) {
        // Prepare data for the WPM chart
        var buckets = histogramData.map(function(currentValue) { // a.k.a. labels
            return currentValue.bucket;
        });

        var counts = histogramData.map(function(currentValue) { // a.k.a. frequencies
            return currentValue.count;
        });

        // TODO: Implement this on the server side where we define histogram constrants for min, max, and step (--> constants defined in one place)
        histogramDataFiller("wpm", buckets, counts);

        var sumOfCounts = counts.reduce(function(accumulator, currentValue) {
            return accumulator + currentValue;
        }, 0);

        var percentages = counts.map(function(currentValue) {
            return Number((currentValue/sumOfCounts * 100).toFixed(2)); // note: rounded values
        });

        var bucketIndex; // contains user score (to be used later)
        var barColors = buckets.map(function(currentValue, index) { // grey bars. excluding the one including user score
            var barColor = "rgba(0, 0, 0, 0.1)"; // default: grey
            switch(index) {
                case 0: // first
                    if (wpmUser < buckets[index+1]) {
                        bucketIndex = index;
                        barColor = "rgba(255, 145, 46, 0.2)"; // orange
                    }
                    break;
                case (buckets.length - 1): // last
                    if (buckets[buckets.length-1] <= wpmUser) {
                        bucketIndex = index;
                        barColor = "rgba(255, 145, 46, 0.2)"; // orange
                    }
                    break;
                default: // everything between the first and the last
                    if (buckets[index] <= wpmUser && wpmUser < buckets[index+1]) {
                        bucketIndex = index;
                        barColor = "rgba(255, 145, 46, 0.2)"; // orange
                    }
                    break;
            }
            return barColor;
        });

        // Calculate a step size for the chart's X-axis
        wpmChartStepSizeX = buckets[1] - buckets[0];

        // Calculate max values for the chart's X and Y axes
        wpmChartMaxX = buckets[buckets.length-1];
        var maxCount = percentages.reduce(function(accumulator, currentValue) {
            return Math.max(accumulator, currentValue);
        });
        wpmChartMaxY = WPM_CHART_STEP_SIZE_Y * Math.ceil(maxCount / WPM_CHART_STEP_SIZE_Y) + WPM_CHART_STEP_SIZE_Y;

        // Create WPM chart
        createWpmChart(
            {
                labels: buckets,
                datasets: [{
                    data: percentages,
                    backgroundColor: barColors
                }]
            },
            null,
            null,
            bucketIndex
        );

        // Calculate faster than XX.XX% (of people who took this typing test)
        var fasterThanPercentage = Number((buckets.filter(function(element) {
            return element < wpmChartStepSizeX * Math.floor(wpmUser / wpmChartStepSizeX);
        }).reduce(function(accumulator, currentValue, currentIndex) {
            return accumulator + counts[currentIndex];
        }, 0) / sumOfCounts * 100)).toFixed(2);

        // Update UI
        $("#wpm_compare").text(fasterThanPercentage + "%");
    }

    /**
     * Create WPM chart
     */
    function createWpmChart(data, maxPlayers, userscoreindex, binindex) {
        // Clear if exists
        if (typeof(this.wpmChart) != 'undefined'){
            if (typeof(this.wpmChart.destroy) != 'undefined'){
                this.wpmChart.destroy();
            }
        }

        // Prepare canvas
        var c = document.getElementById("wpmChart");
        var ctx = c.getContext("2d");
        ctx.clearRect(0, 0, c.width, c.height);

        // Prepare "Your score" data label
        var plugin = {
            afterDatasetsDraw: function(chart) {
                if(typeof(userscoreindex)!='undefined' || typeof(binindex)!='undefined'){
                    var ctx = chart.ctx;
                    chart.data.datasets.forEach(function(dataset, i) {
                        var meta = chart.getDatasetMeta(i);
                        if (!meta.hidden) {
                            meta.data.forEach(function(element, index) {
                                if ( (typeof(userscoreindex) != 'undefined' && index == userscoreindex) || // For scoreBars
                                      (typeof(binindex) != 'undefined' && index == binindex) // For scoreHistogram
                                    ){
                                    // Draw the text in black, with the specified font
                                    ctx.fillStyle = 'rgb(255,145,46)';
                                    var fontSize = 12;
                                    var fontStyle = 'normal';
                                    var fontFamily = 'Helvetica Neue';
                                    ctx.font = Chart.helpers.fontString(fontSize, fontStyle, fontFamily);
                                    // Just naively convert to string for now
                                    var dataString = wpmUser.toString(); //dataset.data[index].toString();
                                    // Make sure alignment settings are correct
                                    ctx.textAlign = 'center';
                                    ctx.textBaseline = 'middle';
                                    var padding = 5;
                                    var position = element.tooltipPosition();
                                    ctx.rotate(Math.PI*2/(i*6));
                                    ctx.fillText(dataString, position.x, position.y - (fontSize / 2) - padding);
                                }
                            });
                        }
                    });
                }
            }
        };

        // Create chart
        wpmChart = Chart.Bar(ctx, {
            type: "bar",
            data: data,
            options: {
                legend: {
                    display: false
                },
                tooltips: {
                    enabled: false
                },
                hover: {
                    mode: null
                },
                scales: {
                    xAxes: [{
                        categoryPercentage: 1.0,
                        barPercentage: 0.8,
                        scaleLabel: {
                            display: true,
                            labelString: "Distribution of WPM",
                            fontSize: 14
                        },
                        ticks: {
                            min: 0,
                            max: wpmChartMaxX,
                            stepSize: wpmChartStepSizeX,
                            maxRotation: 0,
                        },
                        gridLines: {
                            drawOnChartArea: false,
                            offsetGridLines: true
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: "% of participants",
                            fontSize: 14
                        },
                        ticks: {
                            min: 0,
                            max: wpmChartMaxY,
                            stepSize: WPM_CHART_STEP_SIZE_Y,
                        },
                        gridLines: {
                            drawOnChartArea: false
                        }
                    }],
                },
                animation: {
                    // Calculate appropriate label offset for X-axis (onload and onresize)
                    onProgress: function(animation) {
                        // Centre X-scale label
                        var xScale = wpmChart.scales["x-axis-0"];
                        var xLabelOffset = (xScale.getPixelForTick(1) - xScale.getPixelForTick(0)) / 2;
                        wpmChart.options.scales.xAxes[0].ticks.minor.labelOffset = -xLabelOffset;

                        // Centre Y-scale label
                        // var yScale = wpmChart.scales['y-axis-0'];
                        // var yLabelOffset = (yScale.getPixelForTick(0) - yScale.getPixelForTick(1)) / 2;
                        // wpmChart.options.scales.yAxes[0].ticks.minor.labelOffset = yLabelOffset;

                        // Update chart
                        wpmChart.update();
                    }
                },
                responsive: true
            },
            plugins: [plugin]
        });
    }

    /**
     * Create error rate histogram
     */
    function createErrorRateHistogram(histogramData) {
        // Prepare data for the error rate chart
        var buckets = histogramData.map(function(currentValue) { // a.k.a. labels
            return currentValue.bucket;
        });

        var counts = histogramData.map(function(currentValue) { // a.k.a. frequencies
            return currentValue.count;
        });

        // TODO: Implement this on the server side where we define histogram constrants for min, max, and step (--> constants defined in one place)
        histogramDataFiller("error_rate", buckets, counts);

        var sumOfCounts = counts.reduce(function(accumulator, currentValue) {
            return accumulator + currentValue;
        }, 0);

        var percentages = counts.map(function(currentValue) {
            return Number((currentValue/sumOfCounts * 100).toFixed(2)); // note: rounded values
        });

        var bucketIndex; // contains user score (to be used later)
        var barColors = buckets.map(function(currentValue, index) { // grey bars. excluding the one including user score
            var barColor = "rgba(0, 0, 0, 0.1)"; // default: grey
            switch(index) {
                case 0: // first
                    if (errorRateUser < buckets[index+1]) {
                        bucketIndex = index;
                        barColor = "rgba(255, 145, 46, 0.2)"; // orange
                    }
                    break;
                case (buckets.length - 1): // last
                    if (buckets[buckets.length-1] <= errorRateUser) {
                        bucketIndex = index;
                        barColor = "rgba(255, 145, 46, 0.2)"; // orange
                    }
                    break;
                default: // everything between the first and the last
                    if (buckets[index] <= errorRateUser && errorRateUser < buckets[index+1]) {
                        bucketIndex = index;
                        barColor = "rgba(255, 145, 46, 0.2)"; // orange
                    }
                    break;
            }
            return barColor;
        });

        // Calculate a step size for the chart's X-axis
        errorRateChartStepSizeX = buckets[1] - buckets[0];

        // Calculate max values for the error rate chart's X and Y axes
        errorRateChartMaxX = buckets[buckets.length-1];
        var maxCount = percentages.reduce(function(accumulator, currentValue) {
            return Math.max(accumulator, currentValue);
        });
        errorRateChartMaxY = ERROR_RATE_CHART_STEP_SIZE_Y * Math.ceil(maxCount / ERROR_RATE_CHART_STEP_SIZE_Y) + ERROR_RATE_CHART_STEP_SIZE_Y;

        // Create error rate chart
        createErrorRateChart(
            {
                labels: buckets,
                datasets: [{
                    data: percentages,
                    backgroundColor: barColors
                }]
            },
            null,
            null,
            bucketIndex
        );

        // Calculate less errors than XX.XX% (of people who took this typing test)
        var lessErrorsThanPercentage = (100 - Number((buckets.filter(function(element) {
            return element < errorRateChartStepSizeX * Math.floor(errorRateUser / errorRateChartStepSizeX);
        }).reduce(function(accumulator, currentValue, currentIndex) {
            return accumulator + counts[currentIndex];
        }, 0) / sumOfCounts * 100))).toFixed(2);

        // Update UI
        $("#err_compare").text(lessErrorsThanPercentage + "%");
    }

    /**
     * Create error rate chart
     */
    function createErrorRateChart(data, maxPlayers, userscoreindex, binindex){
        // Clear if exists
        if (typeof(this.errorRateChart) != 'undefined'){
            if (typeof(this.errorRateChart.destroy) != 'undefined'){
                this.errorRateChart.destroy();
            }
        }

        // Prepare canvas
        var c = document.getElementById("errorChart");
        var ctx = c.getContext("2d");
        ctx.clearRect(0, 0, c.width, c.height);

        // Prepare "Your score" data label
        var plugin = {
            afterDatasetsDraw: function(chart) {
                if(typeof(userscoreindex)!='undefined' || typeof(binindex)!='undefined'){
                    var ctx = chart.ctx;
                    chart.data.datasets.forEach(function(dataset, i) {
                        var meta = chart.getDatasetMeta(i);
                        if (!meta.hidden) {
                            meta.data.forEach(function(element, index) {
                                if ( (typeof(userscoreindex) != 'undefined' && index == userscoreindex) || // For scoreBars
                                      (typeof(binindex) != 'undefined' && index == binindex) // For scoreHistogram
                                    ){
                                    // Draw the text in black, with the specified font
                                    ctx.fillStyle = 'rgb(255,145,46)';
                                    var fontSize = 12;
                                    var fontStyle = 'normal';
                                    var fontFamily = 'Helvetica Neue';
                                    ctx.font = Chart.helpers.fontString(fontSize, fontStyle, fontFamily);
                                    // Just naively convert to string for now
                                    var dataString = errorRateUser.toString(); //dataset.data[index].toString();
                                    // Make sure alignment settings are correct
                                    ctx.textAlign = 'center';
                                    ctx.textBaseline = 'middle';
                                    var padding = 5;
                                    var position = element.tooltipPosition();
                                    ctx.rotate(Math.PI*2/(i*6));
                                    ctx.fillText(dataString, position.x, position.y - (fontSize / 2) - padding);
                                }
                            });
                        }
                    });
                }
            }
        };

        // Create chart
        errorRateChart = Chart.Bar(ctx, {
            type: "bar",
            data: data,
            options: {
                legend: {
                    display: false
                },
                tooltips: {
                    enabled: false
                },
                hover: {
                    mode: null
                },
                scales: {
                    xAxes: [{
                        categoryPercentage: 1.0,
                        barPercentage: 0.8,
                        scaleLabel: {
                            display: true,
                            labelString: "Distribution of error rate (%)",
                            fontSize: 14
                        },
                        ticks: {
                            min: 0,
                            max: errorRateChartMaxX,
                            stepSize: errorRateChartStepSizeX,
                            maxRotation: 0,
                        },
                        gridLines: {
                            drawOnChartArea: false,
                            offsetGridLines: true
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: "% of participants",
                            fontSize: 14
                        },
                        ticks: {
                            min: 0,
                            max: errorRateChartMaxY,
                            stepSize: ERROR_RATE_CHART_STEP_SIZE_Y,
                        },
                        gridLines: {
                            drawOnChartArea: false
                        }
                    }],
                },
                animation: {
                    // Calculate appropriate label offset for X-axis (onload and onresize)
                    onProgress: function(animation) {
                        // Centre X-scale label
                        var xScale = errorRateChart.scales["x-axis-0"];
                        var xLabelOffset = (xScale.getPixelForTick(1) - xScale.getPixelForTick(0)) / 2;
                        errorRateChart.options.scales.xAxes[0].ticks.minor.labelOffset = -xLabelOffset;

                        // Centre Y-scale label
                        // var yScale = errorRateChart.scales['y-axis-0'];
                        // var yLabelOffset = (yScale.getPixelForTick(0) - yScale.getPixelForTick(1)) / 2;
                        // errorRateChart.options.scales.yAxes[0].ticks.minor.labelOffset = yLabelOffset;

                        // Update chart
                        errorRateChart.update();
                    }
                },
                responsive: true
            },
            plugins: [plugin]
        });
    }
});
