package db

import javax.inject.{Inject, Singleton}

import models.Participant
import slick.driver.MySQLDriver.api._

object Participants {
  def participants = TableQuery[Participants]
}

// MAX NUM OF PARAMETERS IS 22 UNLESS YOU WANT A WORKAROUND
// https://stackoverflow.com/questions/20258417/how-to-get-around-the-scala-case-class-limit-of-22-fields

class Participants(tag: Tag) extends Table[Participant](tag, "PARTICIPANTS") {
  def id = column[Int]("PARTICIPANT_ID", O.PrimaryKey, O.AutoInc)
  def ipAddress = column[Option[String]]("IP_ADDRESS")
  def age = column[Option[Int]]("AGE")
  def gender = column[Option[String]]("GENDER")
  def hasTakenTypingCourse = column[Option[Boolean]]("HAS_TAKEN_TYPING_COURSE")
  def browserString = column[Option[String]]("BROWSER")
  def browserLanguage = column[Option[String]]("BROWSER_LANGUAGE")
  def device = column[Option[String]]("DEVICE")
  def screen_w = column[Option[Int]]("SCREEN_W")
  def screen_h = column[Option[Int]]("SCREEN_H")
  def wpm = column[Option[Double]]("WPM")
  def errorRate = column[Option[Double]]("ERROR_RATE")
  def nativeLanguage = column[Option[String]]("NATIVE_LANGUAGE")
  def timeSpentTyping = column[Option[String]]("TIME_SPENT_TYPING")
  def typeEnglish = column[Option[String]]("TYPE_ENGLISH")
  def fingers = column[Option[String]]("FINGERS")
  def layout = column[Option[String]]("LAYOUT")
  def keyboardType = column[Option[String]]("KEYBOARD_TYPE")
  def usingApp = column[Option[String]]("USING_APP")
  def usingFeatures = column[Option[String]]("USING_FEATURES")

  def * = (id,ipAddress,age,gender,hasTakenTypingCourse,
      browserString,
      browserLanguage, 
      device,
      screen_w, screen_h,
      wpm,errorRate,nativeLanguage,  
      timeSpentTyping,
      typeEnglish,
      fingers,layout,keyboardType,
      usingApp,
      usingFeatures) <> (Participant.tupled, Participant.unapply)
}
