package db

import javax.inject.{Inject, Singleton}
import models.Logdata
import slick.driver.MySQLDriver.api._

object Logdatas {
  implicit val logdatas = TableQuery[Logdatas]
}

class Logdatas (tag: Tag) extends Table[Logdata](tag, "LOG_DATA") {
  def id = column[Int]("LOG_DATA_ID", O.PrimaryKey, O.AutoInc)
  def etype = column[String]("TYPE")
  def key = column[String]("KEY")
  def code = column[String]("CODE")
  def data = column[String]("DATA")
  def input = column[String]("INPUT")
  def pressed = column[String]("PRESSED")
  def timestamp = column[Long]("TIMESTAMP")
  def screen_orientation = column[String]("SCREEN_ORIENTATION")
  def device_orientation = column[String]("DEVICE_ORIENTATION")
  //def screen_size_w = column[String]("SCREEN_W")
  //def screen_size_h = column[String]("SCREEN_H")
  def testSectionId = column[Int]("TEST_SECTION_ID")
  def testSectionFk = foreignKey("TEST_SECTION_FFK", testSectionId, TestSections.testSections)(_.id, onDelete = ForeignKeyAction.Cascade)


  def * = (id, etype, key, code, data, input, 
    pressed, timestamp,
    screen_orientation, device_orientation, 
    //screen_size_w, screen_size_h, 
    testSectionId) <> (Logdata.tupled, Logdata.unapply)
}