/**
 * Various utility functions.
 *
 * Original author: Pierre Dragicevic 
 * Adapted and expanded by Luana Micallef
 */


//
// loads the HTML code from a URL into a string
//
function getHTML(url) {
	try {
		var request;
		if (window.XMLHttpRequest){
			// code for IE7+, Firefox, Chrome, Opera, Safari
  			request=new XMLHttpRequest();
  		}	else	{
  			// code for IE6, IE5
  			request=new ActiveXObject("Microsoft.XMLHTTP");
  		}
		
		request.open("POST", url, false);
		//request.setRequestHeader( "Content-type", "text/xml" );
		request.send();
		//if (request.readyState==4 && request.status == 200)
		//    return request.responseText;
		return request.responseText;
	} catch (err) {
		
		var errmsg = ("<font color='Brown'>Error loading " + url + " (" + err + ").<br>Sorry, this job does not seem to work on your computer.</font><br>");

		if (window.XMLHttpRequest){ 
			try{
				request=new ActiveXObject("Microsoft.XMLHTTP");
				request.open("POST", url, false);
				request.send();
				//if (request.readyState==4 && request.status == 200)
				//	return request.responseText;
				return request.responseText;
			} catch (err) {
				//console.log("getHTML: "+errmsg);
				return errmsg;
			}
		} else {
			//console.log("getHTML: "+errmsg);
	 		return errmsg;
		}	
	//return("<font color='Brown'>Error loading " + url + " (request status " + request.status + ").<br>Sorry, this HIT does not seem to work on your computer.</font><br>");
	}
}

//
// Creates a Likert scale input element
//
function createLikertScale(name, width, labels) {
	var nbValues = labels.length;
	var s = "";
	s += '<table width="' + width + '" border="0" cellspacing="3" style="table-layout:fixed; border-width: 1px; border-color:#CCCCCC; border-style: solid;">';
	for (var i=1; i<=nbValues; i++)
		s += '<col width="' + width/nbValues + '" align="center">';
	s += '<tr style="font-size: 95%">';
	for (var i=1; i<=nbValues; i++)
		s += '<td align="center">' + labels[i-1] + '</td>';
	s += '<tr></tr>';
	for (var i=1; i<=nbValues; i++)
		s += '<td align="center"><input type="radio" name="' + name + '" value="' + i + '">' + i + '<br></td>';
	s += '</tr></table>';
	document.write(s);
}

//
// Recursively checks all HTML form fields inside the given element and returns true if all of they are
// filled in.
//
// - For all INPUT elements of type text, password and textarea, checks that they have a non-null value.
// - For all INPUT elements of type radio and checkbox, checks that at least one of their items is checked.
// - For all SELECT elements, checks that they have a non-null value.
// - All other items, such as INPUT elements of type button, hidden and submit are not checked.
//

function checkAllFields(containerId) {
    
    var fillCounts = new Array();
	var debugstring = checkAllFieldsInsideElement(document.getElementById(containerId), fillCounts, "Elements found:\n\n");
	
	debugstring += "\nNumber of filled elements per name:\n\n";
	var ok = true;
	for (var name in fillCounts) {
		var count = fillCounts[name];
		ok &= (count > 0);
		debugstring += name + " " + fillCounts + "\n";
	}
	
	// **** uncomment this for debugging this function.
	// alert(debugstring);
	
	return ok;
}

function checkNFields(containerId, n) {

	var fillCounts = new Array();
	var debugstring = checkAllFieldsInsideElement(document.getElementById(containerId), fillCounts, "Elements found:\n\n");
	
	debugstring += "\nNumber of filled elements per name:\n\n";
	var ok = true;
	var okCount = 0;
	for (var name in fillCounts) {
		var count = fillCounts[name];
		ok &= (count > 0);
		debugstring += name + " " + fillCounts + "\n";
		if (count > 0) {okCount++;}
	}
	
	// **** uncomment this for debugging this function.
	// alert(debugstring);
	
	return (okCount >= n);
	//return ok;
}

function checkAllFieldsExcl(containerId, excludeName) {
    
    var fillCounts = new Array();
	var debugstring = checkAllFieldsInsideElement(document.getElementById(containerId), fillCounts, "Elements found:\n\n");
	
	debugstring += "\nNumber of filled elements per name:\n\n";
	var ok = true;
	for (var name in fillCounts) {
		var count = fillCounts[name];
		ok &= ((count > 0) || (name == excludeName));
		debugstring += name + " " + fillCounts + "\n";
	}
	
	// **** uncomment this for debugging this function.
	//alert(debugstring);
	
	return ok;
}


//
// This is the method which actually does the work for checkAllFields.
//
// It maintains an associative array 'fillCounts' which stores the number of filled-in elements per element name.
// It also maintains a debugstring, useful for debugging (turn it on above).
//
function checkAllFieldsInsideElement(container, fillCounts, debugstring) {
	var children = container.childNodes;
	for (var i=0; i<children.length; i++) {
		var child = children[i];
		var s = debugstring;
		debugstring = checkAllFieldsInsideElement(child, fillCounts, s);
		//if (child.tagName == "INPUT") {    
		// Above line commented by Luana on 2014-03-14, as with the above line, the function would not check the child types in this section and thus it would not notice that they are empty
			if (child.type == "text" || child.type == "number" || child.type == "password" || child.type == "textarea") {
				// -- Case 1) - standard input field
				if (!(child.name in fillCounts)) fillCounts[child.name] = 0;
				if (child.value) fillCounts[child.name]++;
				debugstring += child.tagName + " " + child.name + " " + child.type + " " + child.value + " " + child.checked + "\n";
			} else if (child.type == "radio" || child.type == "checkbox") {
				// -- Case 2) - radio buttons and check boxes
				if (!(child.name in fillCounts)) fillCounts[child.name] = 0;
				if (child.checked) fillCounts[child.name]++;
				debugstring += child.tagName + " " + child.name + " " + child.type + " " + child.value + " " + child.checked + "\n";
			}
		//} 
		else if (child.tagName == "SELECT") {
			// -- Case 3) - 'select' items (drop down lists, etc.)
			debugstring += child.tagName + " " + child.name + " " + child.type + " " + child.value + " " + child.checked + "\n";
			if (!(child.name in fillCounts)) fillCounts[child.name] = 0;
			if (child.value) fillCounts[child.name]++;
		}
	}
	return debugstring;
}

//
function setAllFieldsEnabled(containerID, enabled, excludeName) {
	setAllFieldsEnabledInsideElement(document.getElementById(containerID), enabled, excludeName);
}

// The recursive function
function setAllFieldsEnabledInsideElement(container, enabled, excludeName) {
	var children = container.childNodes;
	for (var i=0; i<children.length; i++) {
		var child = children[i];
		setAllFieldsEnabledInsideElement(child, enabled, excludeName);
		if (child.name != excludeName) {
			if (child.tagName == "INPUT") {
				child.disabled = !enabled;
			} else if (child.tagName == "SELECT") {
				child.disabled = !enabled;
			}
		}
	}
}

// Taken from http://webcloud.se/log/JavaScript-and-ISO-8601/
function ISODateString(d) {
    function pad(n){
        return n < 10 ? '0' + n : n
    }
    return d.getUTCFullYear()+'-'
    + pad(d.getUTCMonth()+1)+'-'
    + pad(d.getUTCDate())+'T'
    + pad(d.getUTCHours())+':'
    + pad(d.getUTCMinutes())+':'
    + pad(d.getUTCSeconds())+'Z'
}


// Generate a unique user ID 
// src: http://stackoverflow.com/questions/105034/create-guid-uuid-in-javascript
// "a RFC4122 version 4 compliant solution that solves that issue by offsetting the first 
//  13 hex numbers by a hex portion of the timestamp. That way, even if Math.random is on 
//  the same seed, both clients would have to generate the UUID at the exact same millisecond 
//  (or 10,000+ years later) to get the same UUID" [src]
function generateUUID(){
    var d = new Date().getTime();
    if(window.performance && typeof window.performance.now === "function"){
        d += performance.now(); //use high-precision timer if available
    }
    var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
        var r = (d + Math.random()*16)%16 | 0;
        d = Math.floor(d/16);
        return (c=='x' ? r : (r&0x3|0x8)).toString(16);
    });
    return uuid;
}


// Get the number of files in a directory
// ActiveXObject works on IE only
function getFileCountInDir(dirpath){
    var myObject, f, filesCount;
    myObject = new ActiveXObject("Scripting.FileSystemObject");
    f = myObject.GetFolder(dirpath);
    filesCount = f.files.Count;
    return filesCount;
}

// Get the key given the value from an object
function getKeyOfValue(obj,val) {
    for (key in obj)
        if (obj[key] === val)                    
            return key;
    return false;
}
