"""
Image plot editing functions

Author: Luana Micallef, October 2016
"""

import os
from PIL import Image
from PIL import ImageChops
import PIL.ImageOps 

import utilities



# Trim off all the border with the specified border color 
# e.g., border="white" -> removes all white surrounding image
def trimBorder(im, border):
    bg = Image.new(im.mode, im.size, border)
    diff = ImageChops.difference(im, bg)
    bbox = diff.getbbox()
    if bbox:
        return im.crop(bbox)
        
      
# Trim off the axes from the image 
# plotWidth_woAxes is in pixels and assumes a square plot
def trimAxes(imageFileDirPath, imageFileName, outputFileDirPath, plotWidth_woAxes=824):
    
    im = Image.open(imageFileDirPath + os.path.sep + imageFileName)
    im_t = trimBorder(im, "white")
    
    im_t_w, im_t_h = im_t.size
    axisWidth_wNoNos = 5
    
    x1 = im_t_w - plotWidth_woAxes - axisWidth_wNoNos
    y1 = axisWidth_wNoNos
    x2 = x1 + plotWidth_woAxes
    y2 = y1 + plotWidth_woAxes
    
    im_tc = im_t.crop((x1,y1,x2,y2))
    im_tc.save(outputFileDirPath + os.path.sep + imageFileName)
    
    return
    
    
# Trim off the axes from all the images in directory imageFileDirPath
def trimAxesOfImages (imageDirPath, outputDirPath):
    if not os.path.exists(outputDirPath):
        os.makedirs(outputDirPath) #utilities.ensureDirectory(outputDirPath)
        
    imageFileNames = utilities.getFileNamesFromDir(imageDirPath,"png")
    for imageFileName in imageFileNames:
        trimAxes(imageDirPath, imageFileName, outputDirPath)
    return 

