
import utilities
import numpy as np

dataFolder = "../crowdflower+studies/scatterploterrors/"

errorFileNames = utilities.getFileNamesFromDir(dataFolder,"txt")


for errorFile in errorFileNames:

    outCsvFile = open(dataFolder + errorFile.replace(".txt", "_aggregated.csv"), "w")
    outCsvFile.write("pNum,a,a_id,avgAngleError,avgAxisError,avgUserError\n")

    outCsvFileAngleVsError = open(dataFolder + errorFile.replace(".txt", "_AngleVsError.csv"), "w")
    outCsvFileAngleVsError.write("avgAngleError,avgUserError,k,o,r\n")

    outCsvFileAxisVsError = open(dataFolder + errorFile.replace(".txt", "_AxisVsError.csv"), "w")
    outCsvFileAxisVsError.write("avgAxisError,avgUserError,k,o,r\n")

    errorData = np.genfromtxt(dataFolder + errorFile, dtype = None, delimiter = "|", names = True)

    importantData = np.column_stack((errorData["pNum"], errorData["n"].astype(np.int32), errorData["r"], errorData["a"], errorData["angleError"], errorData["axisError"], errorData["error"]))

    users = np.unique(errorData["pNum"])
    ratios = np.unique(errorData["a"])

    totalNumPlotsPerUser = 18.
    maxError = 1.50

    for userID in users:

        users_rows = errorData[np.where(errorData["pNum"] == userID)]
        
        for i,ratio in enumerate(ratios):
            
            ratio_rows = users_rows[np.where(users_rows["a"] == ratio)]
            skippedAnswers = totalNumPlotsPerUser - len(ratio_rows)


            avgAngleError = np.sum(ratio_rows["angleError"])/len(ratio_rows)
            avgAxisError = np.sum(ratio_rows["axisError"])/len(ratio_rows)
            
            avgUserError = np.sum(ratio_rows["error"])
            
            avgUserError += skippedAnswers * maxError

            avgUserError /= totalNumPlotsPerUser

            outCsvFile.write(str(userID) +","+ str(ratio)+","+str(i)+","+str(avgAngleError)+","+str(avgAxisError)+","+str(avgUserError)+"\n")
            outCsvFileAngleVsError.write(str(avgAngleError)+","+str(avgUserError)+","+str(i)+",0,0\n")
            outCsvFileAxisVsError.write(str(avgAxisError)+","+str(avgUserError)+","+str(i)+",0,0\n")

    outCsvFile.close()
    outCsvFileAngleVsError.close()
    outCsvFileAxisVsError.close()
