"""
Function to plot intermediate data for testing

Author: Luana Micallef, January 2016
"""


import numpy as np
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.patches 
import time, os

import utilities


# Saves adjacency matrix containing the pairwise perceived covariance ellipse overlap areas 
def savePerceivedCovEllipseOverlapAreas(overlapAreasMatrix, dataFileName):
    textinfilename = "perceived"
    outfilepath = "temp" + os.path.sep + "covellipse" + os.path.sep + "covellipse_"+textinfilename+"_"+dataFileName.replace(".csv","")+"_"+time.strftime("%Y%m%d_%H%M%S")+"_overlaps.txt"
    utilities.ensureDirectory(outfilepath)
    np.savetxt(outfilepath, overlapAreasMatrix, delimiter=",")


# Plots the actual points and their corresponding cluster covariance ellipse
# Plot is saved in temp/covellipse with filename example covellipse_actual_randNorm_2blobs_100pnts_20160126_114321.png
def plotActualDataPointsAndClusterCovEllipses(actualDatapointsClusters, actualCovEllipses, dataFileName):
    plotDataPointsAndClusterCovEllipses(actualDatapointsClusters, actualCovEllipses, dataFileName, "actual")
    

# Plots the actual points and their corresponding cluster covariance ellipse
# Plot is saved in temp/perccovellipse with filename example covellipse_perceived_randNorm_2blobs_100pnts_20160126_114321.png
def plotPerceivedDataPointsAndClusterCovEllipses(perceivedDatapointsClusters, perceivedCovEllipses, dataFileName):
    plotDataPointsAndClusterCovEllipses(perceivedDatapointsClusters, perceivedCovEllipses, dataFileName, "perceived")



# Plots the data points and their corresponding cluster covariance ellipse
# Plot is saved in temp/covellipse with filename example covellipse__randNorm_2blobs_100pnts_20160126_114321.png
def plotDataPointsAndClusterCovEllipses(datapointsClusters, covEllipses, dataFileName, textinfilename="", ellipsesOnly=False):

    for d in datapointsClusters:
        datapointsCluster = datapointsClusters[d]
        x,y = datapointsCluster.T
        alphaVal = 0 if ellipsesOnly else 0.5
        plt.plot(x, y, 'o', markersize=2, alpha=alphaVal)
        
        covEllipse = covEllipses[d]
        ellip = matplotlib.patches.Ellipse(xy=[covEllipse.xc, covEllipse.yc], width=covEllipse.axis_major*2, height=covEllipse.axis_minor*2, angle=covEllipse.angle, alpha=0.5, color='grey')
        ax = plt.gca()
        ax.add_artist(ellip)
    
    outfilepath = "temp" + os.path.sep + "covellipse" + os.path.sep + "covellipse_"+textinfilename+"_"+dataFileName.replace(".csv","")+"_"+time.strftime("%Y%m%d_%H%M%S")+".png"
    utilities.ensureDirectory(outfilepath)
    
    #plt.show()
    plt.savefig(outfilepath)
    plt.clf()
    