

import matplotlib
import matplotlib.pyplot as plt
import colors
import model
import optimizers
plt.ion()
#import os 
from scatterplotimage import ScatterPlotter
#import clustering
#import model
import utilities
#import colors
#import optimizers
#import plottingintermdata
#import sys
import numpy as np
#from scipy import stats
#import itertools

# Get a scatter plotter
SP = ScatterPlotter(53)

#dataFilePath = "../data/figuresData/differentDesignsData/out5d_thor_uran.csv"
dataFilePath = "../data/isabel/Slices/Isabel_032_converted.csv"


datapoints, datapointsClusters, datapointsClusters_woOutliers, \
    outliers_foreachcluster, corr_perCluster = \
            utilities.ReadCSV(dataFilePath,0,1,hasHeading = True)

#datapoints, datapointsClusters, datapointsClusters_woOutliers, \
#outliers_foreachcluster, corr_perCluster = \
#        utilities.getDataPointsWithClustersFromCSVFile(dataFilePath, hasHeading=True, shuffle=False)
   
TriangleIndices = np.stack(np.triu_indices(len(datapointsClusters), 1), axis=-1)



clustersMeasures = {}
actualCovEllipses = {}
#actualCorrelations = {}
actualSDySDxRatios = {}
for d in range(0,len(datapointsClusters)):
    datapointsCluster = datapointsClusters[d]
    actual_covellipse, actual_minorOnMajorAxis, actual_angle = model.getDataCovarianceEllipse(datapointsCluster)
    clustersMeasures[d] = (actual_minorOnMajorAxis, actual_angle) 
    actualCovEllipses[d] = actual_covellipse
    #actualCorrelations[d] = stats.pearsonr(datapointsCluster[:,0], datapointsCluster[:,1])[0]
    actualSDySDxRatios[d] = model.getSDySDxRatioOfPointCloud(datapointsCluster)

actualPairwiseClusterOverlapMeasures, actualCovEllipsesOverlapAreas = model.getPairwiseClusterOverlapMeasures(actualCovEllipses, datapointsClusters, TriangleIndices)


datapoints, \
datapointsClusters, \
outliers_foreachcluster, \
actualPairwiseClusterOverlapMeasures_relabelled, \
clustersMeasures_relabelled, \
actualCovEllipses_relabelled, \
actualSDySDxRatios_relabelled = model.getRenderingOrderOfClusters(datapoints, \
                                                                  datapointsClusters, \
                                                                  outliers_foreachcluster, \
                                                                  actualPairwiseClusterOverlapMeasures, \
                                                                  clustersMeasures, \
                                                                  actualCovEllipses, \
                                                                  actualSDySDxRatios, \
                                                                  TriangleIndices)

colorDeltas = colors.getDeltaEBetweenCategoricalColorBrewerColors()
color_foreachcluster = colors.getRGBColorsForClusters(actualPairwiseClusterOverlapMeasures_relabelled, colorDeltas, TriangleIndices)   


DataBoundingBox = utilities.getBBox(datapoints)
marker_size = 20
marker_opacity = 100
image_width = 1000
image_aspect_ratio = 1

CurrDesign = [marker_size, marker_opacity, image_width, image_aspect_ratio]

fig, scatter_plot = plt.subplots();
fig.tight_layout()
background = fig.patch
background.set_facecolor((1,1,1,0))
scatter_plot.axis('off')
scatter_plot.grid(False)

#Design(marker_size, marker_opacity, image_aspect_ratio, image_width)

for d in range(len(datapointsClusters)):
    SP.FillPlot(fig, scatter_plot, datapointsClusters[d],
                        DataBoundingBox,
                        marker_size,
                        marker_opacity,
                        image_width,
                        image_aspect_ratio,
                        color_foreachcluster[d])





def SetMaxMarkerSize(max_marker_size, sp = SP):

    sp.MaxMarkerSize = max_marker_size


def Design(NewSize, NewOpacity, NewRatio, ImageWidth = 1000, UseColors = True, ShowAxes = True, cdesign = CurrDesign, ChangeMaxMarkerSize = True):
    
    if ChangeMaxMarkerSize:
        SP.MaxMarkerSize = NewSize
    
    scatter_plot.clear()
    fig.tight_layout()

    cdesign[0] = NewSize
    cdesign[1] = NewOpacity
    cdesign[2] = NewRatio
    cdesign[3] = ImageWidth

    for d in range(len(datapointsClusters)):

        color = color_foreachcluster[d]
        if UseColors == False:
            color = [0,0,0]

        SP.FillPlot(fig, scatter_plot, datapointsClusters[d],
                            DataBoundingBox,
                            NewSize,
                            NewOpacity,
                            ImageWidth,
                            NewRatio,
                            color)
    if ShowAxes == False:
        scatter_plot.axis('off')

    #fontSize = 40
    #
    #axes = plt.gca()
    #
    #plt.gcf().subplots_adjust(bottom=0.04)
    #plt.gcf().subplots_adjust(left=0.07)
    #
    #for tick in axes.yaxis.get_major_ticks():
    #    tick.label.set_fontsize(fontSize)
    #
    #for tick in axes.xaxis.get_major_ticks():
    #   tick.label.set_fontsize(fontSize)

    plt.savefig(dataFilePath.replace(".csv",".png"))

    #if SaveFigure:
    #    optimizers.PlotWinner([], None, winningplotFilePath, "", datapointsClusters, datapoints, color_foreachcluster, SP, DataBoundingBox)

def SetTicksFontSize(xsize, ysize):

    axes = plt.gca()

    for tick in axes.yaxis.get_major_ticks():
        tick.label.set_fontsize(xsize)
    
    for tick in axes.xaxis.get_major_ticks():
       tick.label.set_fontsize(ysize)

    plt.show()

def AdjustPaddingSize(bottom_size, left_pt):

    plt.gcf().subplots_adjust(bottom=bottom_size)
    plt.gcf().subplots_adjust(left=left_pt)

def SetAxesLimit(x_min, x_max, y_min, y_max):

    axes = plt.gca()
    axes.set_autoscale_on(False)

    scatter_plot.set_xlim([x_min,x_max])
    scatter_plot.set_ylim([y_min,y_max])

def Save(SaveLog = False, cdesign = CurrDesign):

    plt.savefig(dataFilePath.replace(".csv",".png"))

    if SaveLog:

        axes = plt.gca()

        logFile = open(dataFilePath.replace(".csv",".txt"),"w")

        logFile.write("axes ranges: x: "+str(scatter_plot.get_xlim())+", y: "+str(scatter_plot.get_ylim())+"\n")
        logFile.write("font ticks: x: "+str(axes.xaxis.get_major_ticks()[0].label.get_fontsize())+", y: "+str(axes.yaxis.get_major_ticks()[0].label.get_fontsize())+"\n")
        #logFile.write("spacing: bottom: "+str(plt.gcf().bottom())+", left: "+str(plt.gcf().left())+"\n")
        logFile.write("design :" +str(cdesign)+"\n")

        logFile.close()

def AddEllipses(EllipsesScaleFact = 2):

    for d in range(len(datapointsClusters)):

        ellipse = model.getCovEllipseForPoints(datapointsClusters[d], 1.5)

        ellip = matplotlib.patches.Ellipse(xy=[ellipse.xc, ellipse.yc], width=ellipse.axis_major*EllipsesScaleFact, height=ellipse.axis_minor*EllipsesScaleFact, alpha=1,  angle=ellipse.angle, facecolor = 'none', edgecolor = 'black', linewidth = 5)
        
        ax = plt.gca()
        ax.add_artist(ellip)


def DesignWithEllipses(NewSize, NewOpacity, NewRatio, ImageWidth = 1000, EllipsesScaleFact = 2, SaveFig = False):
    
    scatter_plot.clear()
    plt.cla()
    
    fig.tight_layout()

    for d in range(len(datapointsClusters)):

        ellipse = model.getCovEllipseForPoints(datapointsClusters[d], 1.5)

        SP.FillPlot(fig, scatter_plot, datapointsClusters[d],
                            DataBoundingBox,
                            NewSize,
                            NewOpacity,
                            ImageWidth,
                            NewRatio,
                            color_foreachcluster[d])

        ellip = matplotlib.patches.Ellipse(xy=[ellipse.xc, ellipse.yc], width=ellipse.axis_major*EllipsesScaleFact, height=ellipse.axis_minor*EllipsesScaleFact, alpha=1,  angle=ellipse.angle, facecolor = 'none', edgecolor = 'black', linewidth = 5)
        
        ax = plt.gca()
        ax.add_artist(ellip)



    #fontSize = 20
    #
    #axes = plt.gca()
    #
    #plt.xticks(axes.get_xlim(),['0','1'])
    #plt.yticks(axes.get_ylim(),['0',str(NewRatio)])
    #
    #
    #for tick in axes.yaxis.get_major_ticks():
    #    tick.label.set_fontsize(fontSize)
    #
    #for tick in axes.xaxis.get_major_ticks():
    #   tick.label.set_fontsize(fontSize)

    #if SaveFig:
    #    plt.savefig("fig_ellipse"+str(NewRatio).replace(".","")+".png")



#if __name__ == "__main__":

