import os 
from scatterplotimage import ScatterPlotter
#import clustering
import model
import utilities
import colors
import optimizers
import plottingintermdata
import sys
import numpy as np
from scipy import stats
import itertools


dataFilesDir = ".." + os.path.sep + "data" + os.path.sep + "study2Data/clusters" #"study2Data/outliers" #"study2Data/corr" #"study2Data/clusters"

design_matlab = [6, 255, 1120, 0.75]
design_rrensink = [2, 255, 300, 1]
design_r = [6, 255, 480, 1]

design = design_rrensink

dataFileNames = utilities.getFileNamesFromDir(dataFilesDir,"csv")

for dataFileName in dataFileNames:

    if "pbc_converted5k" not in dataFileName and "SenseYourCity_converted4k" not in dataFileName:
        continue

    print "processing "+dataFileName

    dataFilePath = dataFilesDir + os.path.sep + dataFileName

    datapoints, datapointsClusters, datapointsClusters_woOutliers, \
    outliers_foreachcluster, corr_perCluster = \
            utilities.getDataPointsWithClustersFromCSVFile(dataFilePath, hasHeading=True, shuffle=False)
    
    DataBoundingBox = utilities.getBBox(datapoints)
    #datapointsClusters = {0:datapoints}
    #datapointsClusters = clustering.clusterDataPoints(datapoints, maxK=maxClusters)  # use this to detect the number of clusters in the data points
    TriangleIndices = np.stack(np.triu_indices(len(datapointsClusters), 1), axis=-1)
     
     
    # Compute covariance ellipse and its properties for each actual data points cluster
    clustersMeasures = {}
    actualCovEllipses = {}
    #actualCorrelations = {}
    actualSDySDxRatios = {}
    for d in range(0,len(datapointsClusters)):
        datapointsCluster = datapointsClusters[d]
        actual_covellipse, actual_minorOnMajorAxis, actual_angle = model.getDataCovarianceEllipse(datapointsCluster)
        clustersMeasures[d] = (actual_minorOnMajorAxis, actual_angle) 
        actualCovEllipses[d] = actual_covellipse
        #actualCorrelations[d] = stats.pearsonr(datapointsCluster[:,0], datapointsCluster[:,1])[0]
        actualSDySDxRatios[d] = model.getSDySDxRatioOfPointCloud(datapointsCluster)
        
    # Compute the cluster overlap measure for each pair of clusters
    actualPairwiseClusterOverlapMeasures, actualCovEllipsesOverlapAreas = model.getPairwiseClusterOverlapMeasures(actualCovEllipses, datapointsClusters, TriangleIndices)
   
    # Compute rendering order of clusters
    datapoints, \
    datapointsClusters, \
    outliers_foreachcluster, \
    actualPairwiseClusterOverlapMeasures_relabelled, \
    clustersMeasures_relabelled, \
    actualCovEllipses_relabelled, \
    actualSDySDxRatios_relabelled = model.getRenderingOrderOfClusters(datapoints, \
                                                                      datapointsClusters, \
                                                                      outliers_foreachcluster, \
                                                                      actualPairwiseClusterOverlapMeasures, \
                                                                      clustersMeasures, \
                                                                      actualCovEllipses, \
                                                                      actualSDySDxRatios, \
                                                                      TriangleIndices)
    

    colorDeltas = colors.getDeltaEBetweenCategoricalColorBrewerColors()
    # Get distinguishable RGB colors for clusters
    # Each color is a tuple of the form (r,g,b) where each of r, g and b values is in [0,1]
    color_foreachcluster = colors.getRGBColorsForClusters(actualPairwiseClusterOverlapMeasures_relabelled, colorDeltas, TriangleIndices)   


    ellipsesDir = dataFilesDir+ os.path.sep+"Ellipses/"
    utilities.ensureDirectory(ellipsesDir)

    utilities.CreateEllipseImages(DataBoundingBox, design, datapointsClusters, color_foreachcluster, ellipsesDir + "/"+dataFileName.replace(".csv",".png"), ellipses_scale = 1.3)

