import numpy as np

import controller
import robot_finger


DATA_DIR = 'data\\'


def setup():
    '''
    Run this function after you restart the controller to calibrate the
    controller to your robot.
    '''
    robot = robot_finger.RobotFinger()
    print('\nMove finger to upper position. Make sure all the wires are'
          ' thight. Press the button.\nThen move robot finger to lower'
          ' position and again make sure all the wires are thight and press'
          ' the button.')
    result = robot.setup()
    print('\nYou may want to add default limit values below to your arduino'
          ' source code so that you do not need to perform setup each time you'
          ' restart your controller.')
    print(('\nint limitUpperMax = {};\n'
           'int limitUpperMin = {};\n'
           'int limitLowerMax = {};\n'
           'int limitLowerMin = {};\n'
           'int limitFingerMax = {};\n'
           'int limitFingerMin = {};\n').format(
               result[0], result[3], result[1], result[4],
               result[2], result[5]))
    print("Setup done.")


def train(attempts=10, trails_per_attempt=3, max_time=np.inf, antagonist=True):
    # initialize controller with 10 attempts
    opt_cont = controller.Controller(10, antagonist, trails=trails_per_attempt)

    # train controller
    opt_cont.run(attempts, trails_per_attempt, max_time=max_time)
    result, accuracies = opt_cont.get_result()

    # save results
    opt_cont.save_results(DATA_DIR, "results")
    with open(DATA_DIR + filename+'_p.txt', 'w') as f:
        for item in result:
            f.write("{} ".format(item))

    opt_cont.close()


if __name__ == '__main__':
    train()
    # setup()

